package com.biz.crm.mdm.business.cost.center.local.service.internal;

import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.SapFiCostCenterDto;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;


/**
 * 成本中心自动更新定时任务     job
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.15 13:39
 */
@Slf4j
@Service
public class CostCenterAutoSyncXxlJob {


    @Autowired(required = false)
    private CostCenterService costCenterService;

    /**
     * 成本中心自动更新定时任务 每天4点自动执行
     */
    @DynamicTaskService(cornExpression = "0 0 2 * * ?", taskDesc = "成本中心自动更新定时任务")
    public void autoSyncXxlJob() {
        //TODO  需要改成  定时任务分片+redis锁
        log.info("=====>    成本中心同步[{}] start    <=====", DateUtil.dateStrNowAll());
        SapFiCostCenterDto dto = new SapFiCostCenterDto();
        Date startDate = DateUtil.dateAddDay(new Date(), -7);
        dto.setI_ZDATE_FROM(DateUtil.date_yyyyMMdd.format(startDate));
        dto.setI_ZDATE_TO(DateUtil.date_yyyyMMdd.format(new Date()));
        costCenterService.pullCostCenterList(dto);
        log.info("=====>    成本中心同步[{}] end    <=====", DateUtil.dateStrNowAll());

    }

}
