package com.biz.crm.mdm.business.cost.center.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.cost.center.local.entity.CostCenter;
import com.biz.crm.mdm.business.cost.center.local.entity.CostCenterRelation;
import com.biz.crm.mdm.business.cost.center.local.repository.CostCenterRepository;
import com.biz.crm.mdm.business.cost.center.local.repository.ICostCenterRelationRepository;
import com.biz.crm.mdm.business.cost.center.local.service.ICostCenterRelationService;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterRelationDto;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterRelationVo;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.type.YesNoType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author: chenlong
 * @date: 2022/12/3 14:38
 * @description: 成本中心(CostCenter)表服务实现类
 */
@Service
public class CostCenterVoServiceImpl implements CostCenterVoService {

    @Autowired(required = false)
    private CostCenterRepository costCenterRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private ICostCenterRelationService iCostCenterRelationService;

    /**
     * 通过成本中心编码批量查询生效成本中心数据
     *
     * @param costCenterCodes
     * @param effective       Y或N  是否排除不生效的数据
     * @return
     */
    @Override
    public List<CostCenterVo> findByCodes(List<String> costCenterCodes, String effective) {
        if (CollectionUtils.isEmpty(costCenterCodes)) {
            return Lists.newArrayList();
        }

        if (StringUtils.isEmpty(effective)) {
            //默认查全部
            effective = "N";
        }

        List<CostCenter> list = this.costCenterRepository.lambdaQuery()
                .in(CostCenter::getCostCenterCode, costCenterCodes)
                .eq(StringUtils.equals("Y", effective), CostCenter::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(StringUtils.equals("Y", effective), CostCenter::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
                .list();
        return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(list, CostCenter.class, CostCenterVo.class, HashSet.class, ArrayList.class));
    }

    @Override
    public List<CostCenterRelationVo> findByCondition(CostCenterRelationDto costCenterRelationDto) {
        if (Objects.isNull(costCenterRelationDto)) {
            return null;
        }
        return iCostCenterRelationService.findByCondition(costCenterRelationDto);
    }
}
