/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.cost.center.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterDto;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterProfitsSelectDto;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterSelectDto;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterService;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.SapFiCostCenterDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/costCenter"})
@Api(tags={"MDM-\u6210\u672c\u4e2d\u5fc3"})
public class CostCenterController {
    private static final Logger log = LoggerFactory.getLogger(CostCenterController.class);
    @Autowired
    private CostCenterService costCenterService;
    @Autowired
    private CostCenterVoService costCenterVoService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<CostCenterVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="costCenterDto", value="\u6210\u672c\u4e2d\u5fc3dto") CostCenterDto costCenterDto) {
        try {
            Page page = this.costCenterService.findByConditions(pageable, costCenterDto);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<CostCenterVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            CostCenterVo centerVo = this.costCenterService.findById(id);
            return Result.ok((Object)centerVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping(value={"delete"})
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.costCenterService.delete(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="PATCH")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.costCenterService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="PATCH")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.costCenterService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6210\u672c\u4e2d\u5fc3\u4e0b\u62c9")
    @PostMapping(value={"findFormSelectList"})
    public Result<List<CommonSelectVo>> findFormSelectList(@ApiParam(value="\u6210\u672c\u4e2d\u5fc3\u4e0b\u62c9\u53c2\u6570dto") @RequestBody CostCenterSelectDto dto) {
        try {
            List list = this.costCenterService.findFormSelectList(dto);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5229\u6da6\u4e2d\u5fc3\u4e0b\u62c9")
    @PostMapping(value={"findProfitsFormSelectList"})
    public Result<List<CommonSelectVo>> findProfitsFormSelectList(@ApiParam(value="\u5229\u6da6\u4e2d\u5fc3\u4e0b\u62c9\u53c2\u6570dto") @RequestBody CostCenterProfitsSelectDto dto) {
        try {
            List list = this.costCenterService.findProfitsFormSelectList(dto);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u62c9\u53d6\u6210\u672c\u4e2d\u5fc3\u6570\u636e")
    @PostMapping(value={"/pullCostCenterList"})
    public Result<?> pullCostCenterList(@RequestBody SapFiCostCenterDto dto) {
        try {
            this.costCenterService.pullCostCenterList(dto);
            return Result.ok((String)"\u6570\u636e\u62c9\u53d6\u6210\u529f\uff01");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u6279\u91cf\u67e5\u8be2\u6210\u672c\u4e2d\u5fc3\u6570\u636e")
    @GetMapping(value={"/findByCodes"})
    public Result<List<CostCenterVo>> findByCodes(@RequestParam(value="costCenterCodes") List<String> costCenterCodes, @RequestParam(value="effective") String effective) {
        try {
            return Result.ok((Object)this.costCenterVoService.findByCodes(costCenterCodes, effective));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

