/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.cost.center.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.cost.center.local.service.ICostCenterRelationService;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterRelationDto;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterWithholdingDetailDto;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterVoService;
import com.biz.crm.mdm.business.cost.center.sdk.service.ICostCenterRelationVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterRelationVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/costCenterRelation"})
@Api(tags={"MA\u6210\u672c\u4e2d\u5fc3\u6620\u5c04\u5173\u7cfb"})
public class ICostCenterRelationController {
    private static final Logger log = LoggerFactory.getLogger(ICostCenterRelationController.class);
    @Resource
    private ICostCenterRelationService iCostCenterRelationService;
    @Autowired(required=false)
    private CostCenterVoService costCenterVoService;
    @Autowired(required=false)
    private ICostCenterRelationVoService iCostCenterRelationVoService;

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={""})
    public Result<?> create(@RequestBody CostCenterRelationDto dto) {
        try {
            this.iCostCenterRelationService.create(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<CostCenterRelationVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            CostCenterRelationVo relationVo = this.iCostCenterRelationService.findById(id);
            return Result.ok((Object)relationVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PatchMapping(value={""})
    public Result<?> update(@RequestBody CostCenterRelationDto dto) {
        try {
            this.iCostCenterRelationService.update(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping(value={"delete"})
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.iCostCenterRelationService.delete(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u6570\u636e")
    @GetMapping(value={"findByCondition"})
    public Result<List<CostCenterRelationVo>> findByCondition(CostCenterRelationDto costCenterRelationDto) {
        try {
            List relationVos = this.costCenterVoService.findByCondition(costCenterRelationDto);
            return Result.ok((Object)relationVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u9884\u63d0\u660e\u7ec6\u5173\u8054\u6210\u672c\u4e2d\u5fc3\u4e13\u7528")
    @PostMapping(value={"withholdingDetailMap"})
    public Result<Map<String, List<CostCenterRelationVo>>> withholdingDetailMap(@RequestBody CostCenterWithholdingDetailDto dto) {
        try {
            return Result.ok((Object)this.iCostCenterRelationVoService.withholdingDetailMap(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

