/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.cost.center.local.helper;

import com.biz.crm.mdm.business.cost.center.local.entity.CostCenterRelation;
import com.biz.crm.mdm.business.cost.center.local.repository.ICostCenterRelationRepository;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterRelationDto;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class ICostCenterRelationHelper {
    private static final Logger log = LoggerFactory.getLogger(ICostCenterRelationHelper.class);
    @Resource
    private ICostCenterRelationRepository iCostCenterRelationRepository;

    public void verifyEmpty(CostCenterRelationDto dto) {
        Assert.hasText((String)dto.getCostCenterCode(), (String)"\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public String verifyUniqueness(CostCenterRelationDto dto) {
        StringBuilder sb = new StringBuilder(this.handleStr(dto.getBusinessFormatCode()));
        sb.append(this.handleStr(dto.getBusinessUnitCode()));
        sb.append(this.handleStr(dto.getExpenseCenter()));
        sb.append(this.handleStr(dto.getCustomerCode()));
        sb.append(this.handleStr(dto.getCustomerRetailerCode()));
        sb.append(this.handleStr(dto.getSalesGroupCode()));
        sb.append(this.handleStr(dto.getSalesInstitutionCode()));
        sb.append(this.handleStr(dto.getSalesOrgCode()));
        sb.append(this.handleStr(dto.getCustomerRetailerRegion()));
        String uniqueKey = DigestUtils.md5Hex((String)sb.toString());
        CostCenterRelation entity = this.iCostCenterRelationRepository.findByUniqueKey(uniqueKey);
        Assert.isTrue((ObjectUtils.isEmpty((Object)((Object)entity)) || entity.getId().equals(dto.getId()) ? 1 : 0) != 0, (String)"\u5df2\u7ecf\u5b58\u5728\u6570\u636e\u4fe1\u606f");
        return uniqueKey;
    }

    private String handleStr(String code) {
        return StringUtils.hasText((String)code) ? code : "&";
    }
}

