/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.cost.center.local.imports;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.cost.center.local.helper.ICostCenterRelationHelper;
import com.biz.crm.mdm.business.cost.center.local.repository.CostCenterRepository;
import com.biz.crm.mdm.business.cost.center.local.service.ICostCenterRelationService;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterRelationDto;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterRelationImportVo;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class ICostCenterRelationImportProcess
implements ImportProcess<CostCenterRelationImportVo> {
    private static final Logger log = LoggerFactory.getLogger(ICostCenterRelationImportProcess.class);
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private DictDataVoService dictDataVoService;
    @Resource
    private ICostCenterRelationService iCostCenterRelationService;
    @Resource
    private ICostCenterRelationHelper iCostCenterRelationHelper;
    @Resource
    private CustomerRetailerVoService customerRetailerVoService;
    @Resource
    private CostCenterRepository costCenterRepository;
    @Resource
    private CustomerChannelVoService customerChannelVoService;
    @Resource
    private SalesOrgVoService salesOrgVoService;
    @Resource
    private CustomerVoService customerVoService;
    private Map<String, List<DictDataVo>> dictMap = Maps.newHashMap();

    @Transactional(rollbackFor={Exception.class})
    public Map<Integer, String> execute(LinkedHashMap<Integer, CostCenterRelationImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Optional<CostCenterRelationImportVo> first = data.values().stream().findFirst();
        if (!first.isPresent()) {
            return null;
        }
        try {
            this.initDict();
            CostCenterRelationDto dto = this.validate(first.get());
            this.iCostCenterRelationService.create(dto);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            String error = ExceptionStackMsgUtil.stackMsg((Exception)e);
            log.error("\u6210\u672c\u4e2d\u5fc3\u6620\u5c04\u5173\u7cfb\u5bfc\u5165\u5f02\u5e38:{}", (Object)error);
            throw new IllegalArgumentException("\u5bfc\u5165\u5f02\u5e38[" + error + "]");
        }
        return null;
    }

    private void initDict() {
        this.dictMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{"mdm_business_format", "mdm_business_unit", "tpm_expense_center", "MDM_CUSTOMIZE_ORG"}));
    }

    private CostCenterRelationDto validate(CostCenterRelationImportVo vo) {
        CostCenterRelationDto dto = (CostCenterRelationDto)this.nebulaToolkitService.copyObjectByBlankList((Object)vo, CostCenterRelationDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.verifyDictCode(dto);
        vo.setCustomerRetailerCode(StringUtils.hasText((String)vo.getCustomerRetailerCode()) ? vo.getCustomerRetailerCode() : vo.getCustomerRetailerName());
        if (BusinessUnitEnum.VERTICAL.getCode().equals(vo.getBusinessUnitCode())) {
            Assert.hasText((String)vo.getCustomerRetailerCode(), (String)"\u96f6\u552e\u5546\u5fc5\u586b");
        }
        if (StringUtils.hasText((String)vo.getCustomerRetailerCode())) {
            List customerRetailerVos = this.customerRetailerVoService.findByCodeOrName((List)Lists.newArrayList((Object[])new String[]{vo.getCustomerRetailerCode()}));
            Assert.notEmpty((Collection)customerRetailerVos, (String)"\u672a\u67e5\u8be2\u5230\u96f6\u552e\u5546\u4fe1\u606f");
            dto.setCustomerRetailerCode(((CustomerRetailerVo)customerRetailerVos.get(0)).getCustomerRetailerCode());
            dto.setCustomerRetailerName(((CustomerRetailerVo)customerRetailerVos.get(0)).getCustomerRetailerName());
        }
        vo.setCostCenterCode(StringUtils.hasText((String)vo.getCostCenterCode()) ? vo.getCostCenterCode() : vo.getCostCenterName());
        Assert.hasText((String)dto.getCostCenterCode(), (String)"\u6210\u672c\u4e2d\u5fc3\u5fc5\u586b");
        List<CostCenterVo> costCenterVos = this.costCenterRepository.findByCodeOrName(Lists.newArrayList((Object[])new String[]{dto.getCostCenterCode()}));
        Assert.notEmpty(costCenterVos, (String)"\u672a\u67e5\u8be2\u5230\u6210\u672c\u4e2d\u5fc3\u4fe1\u606f");
        dto.setCostCenterCode(costCenterVos.get(0).getCostCenterCode());
        dto.setCostCenterName(costCenterVos.get(0).getCostCenterName());
        vo.setCustomerChannelCode(StringUtils.hasText((String)vo.getCustomerChannelCode()) ? vo.getCustomerChannelCode() : vo.getCustomerChannelName());
        if (StringUtils.hasText((String)dto.getCustomerChannelCode())) {
            List customerChannelVos = this.customerChannelVoService.findByCodeOrName((List)Lists.newArrayList((Object[])new String[]{dto.getCustomerChannelCode()}));
            Assert.notEmpty((Collection)customerChannelVos, (String)"\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u6e20\u9053\u4fe1\u606f");
            dto.setCustomerChannelCode(((CustomerChannelVo)customerChannelVos.get(0)).getCustomerChannelCode());
            dto.setCustomerChannelName(((CustomerChannelVo)customerChannelVos.get(0)).getCustomerChannelName());
        }
        String salesInstitutionCode = dto.getSalesInstitutionCode();
        String salesGroupCode = dto.getSalesGroupCode();
        String salesOrgCode = dto.getSalesOrgCode();
        if (StringUtils.hasText((String)salesInstitutionCode) || StringUtils.hasText((String)salesGroupCode) || StringUtils.hasText((String)salesOrgCode)) {
            SalesOrgVo salesOrgVo;
            List collect;
            Assert.hasText((String)vo.getCustomerChannelCode(), (String)"\u5ba2\u6237\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
            ArrayList codeOrName = Lists.newArrayList();
            vo.setSalesInstitutionCode(StringUtils.hasText((String)vo.getSalesInstitutionCode()) ? vo.getSalesInstitutionCode() : vo.getSalesInstitutionName());
            if (StringUtils.hasText((String)salesInstitutionCode)) {
                codeOrName.add(salesInstitutionCode);
            }
            vo.setSalesOrgCode(StringUtils.hasText((String)vo.getSalesOrgCode()) ? vo.getSalesOrgCode() : vo.getSalesOrgName());
            if (StringUtils.hasText((String)salesOrgCode)) {
                codeOrName.add(salesOrgCode);
            }
            vo.setSalesGroupCode(StringUtils.hasText((String)vo.getSalesGroupCode()) ? vo.getSalesGroupCode() : vo.getSalesGroupName());
            if (StringUtils.hasText((String)salesGroupCode)) {
                codeOrName.add(salesGroupCode);
            }
            List salesOrgAll = this.salesOrgVoService.findByCodeOrName((List)codeOrName);
            Assert.notEmpty((Collection)salesOrgAll, (String)"\u672a\u67e5\u8be2\u5230\u9500\u552e\u7ec4\u7ec7\u4fe1\u606f");
            Assert.hasText((String)dto.getCustomerChannelName(), (String)"\u6e20\u9053\u4fe1\u606f\u9519\u8bef");
            Assert.hasText((String)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4fe1\u606f\u9519\u8bef");
            List salesOrgVos = salesOrgAll.stream().filter(o -> dto.getCustomerChannelCode().equals(o.getChannelCode()) && dto.getBusinessFormatCode().equals(o.getBusinessFormatCode())).collect(Collectors.toList());
            Assert.notEmpty(salesOrgVos, (String)"\u9500\u552e\u673a\u6784\u4e1a\u6001\u6e20\u9053\u4e0d\u5339\u914d");
            if (StringUtils.hasText((String)salesInstitutionCode)) {
                collect = salesOrgVos.stream().filter(o -> o.getSalesOrgCode().equals(salesInstitutionCode) || o.getSalesOrgName().equals(salesInstitutionCode) || o.getErpCode().equals(salesInstitutionCode)).collect(Collectors.toList());
                Assert.isTrue((collect.size() == 1 ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u9500\u552e\u673a\u6784\u6216\u8005\u627e\u5230\u591a\u4e2a");
                salesOrgVo = (SalesOrgVo)collect.get(0);
                dto.setSalesInstitutionCode(salesOrgVo.getSalesOrgCode());
                dto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
            }
            if (StringUtils.hasText((String)salesOrgCode)) {
                Assert.hasText((String)dto.getSalesInstitutionCode(), (String)"\u9500\u552e\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
                collect = salesOrgVos.stream().filter(o -> (o.getSalesOrgCode().equals(salesOrgCode) || o.getSalesOrgName().equals(salesOrgCode) || o.getErpCode().equals(salesOrgCode)) && o.getParentCode().equals(dto.getSalesInstitutionCode())).collect(Collectors.toList());
                Assert.isTrue((collect.size() == 1 ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u9500\u552e\u90e8\u95e8\u6216\u8005\u627e\u5230\u591a\u4e2a");
                salesOrgVo = (SalesOrgVo)collect.get(0);
                dto.setSalesOrgCode(salesOrgVo.getSalesOrgCode());
                dto.setSalesOrgName(salesOrgVo.getSalesOrgName());
            }
            if (StringUtils.hasText((String)salesGroupCode)) {
                Assert.hasText((String)dto.getSalesOrgCode(), (String)"\u9500\u552e\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
                collect = salesOrgVos.stream().filter(o -> (o.getSalesOrgCode().equals(salesGroupCode) || o.getSalesOrgName().equals(salesGroupCode) || o.getErpCode().equals(salesGroupCode)) && o.getParentCode().equals(dto.getSalesOrgCode())).collect(Collectors.toList());
                Assert.isTrue((collect.size() == 1 ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u9500\u552e\u7ec4\u6216\u8005\u627e\u5230\u591a\u4e2a");
                salesOrgVo = (SalesOrgVo)collect.get(0);
                dto.setSalesGroupCode(salesOrgVo.getSalesOrgCode());
                dto.setSalesGroupName(salesOrgVo.getSalesOrgName());
            }
        }
        vo.setCustomerCode(StringUtils.hasText((String)vo.getCustomerCode()) ? vo.getCustomerCode() : vo.getCustomerName());
        if (StringUtils.hasText((String)dto.getCustomerCode())) {
            Assert.hasText((String)dto.getSalesInstitutionName(), (String)"\u9500\u552e\u673a\u6784\u4fe1\u606f\u9519\u8bef");
            Assert.hasText((String)dto.getCustomerChannelName(), (String)"\u6e20\u9053\u4fe1\u606f\u9519\u8bef");
            Assert.hasText((String)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4fe1\u606f\u9519\u8bef");
            List customerVos = this.customerVoService.findByCodeOrName((List)Lists.newArrayList((Object[])new String[]{dto.getCustomerCode()}));
            Assert.notEmpty((Collection)customerVos, (String)"\u672a\u627e\u5230\u5ba2\u6237\u4fe1\u606f");
            List collect = customerVos.stream().filter(o -> o.getSalesInstitutionCode().equals(dto.getSalesInstitutionCode()) && o.getCustomerChannelCode().equals(dto.getCustomerChannelCode()) && o.getBusinessFormatCode().equals(dto.getBusinessFormatCode())).collect(Collectors.toList());
            Assert.isTrue((collect.size() == 1 ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u5ba2\u6237\u6216\u8005\u627e\u5230\u591a\u4e2a");
            dto.setCustomerCode(((CustomerVo)collect.get(0)).getCustomerCode());
            dto.setCustomerName(((CustomerVo)collect.get(0)).getCustomerName());
        }
        return dto;
    }

    private void verifyDictCode(CostCenterRelationDto vo) {
        vo.setBusinessFormatCode(this.findDictValueOrCode(vo.getBusinessFormatCode(), "mdm_business_format"));
        Assert.hasText((String)vo.getBusinessFormatCode(), (String)"\u672a\u914d\u7f6e\u8be5\u4e1a\u6001");
        vo.setBusinessUnitCode(this.findDictValueOrCode(vo.getBusinessUnitCode(), "mdm_business_unit"));
        Assert.hasText((String)vo.getBusinessUnitCode(), (String)"\u672a\u914d\u7f6e\u8be5\u4e1a\u52a1\u5355\u5143");
        if (BusinessUnitEnum.VERTICAL.getCode().equals(vo.getBusinessUnitCode())) {
            Assert.hasText((String)vo.getExpenseCenter(), (String)"\u8d39\u7528\u4e2d\u5fc3\u5fc5\u586b");
            Assert.hasText((String)vo.getCustomerRetailerRegion(), (String)"\u533a\u57df\u5fc5\u586b");
        }
        if (StringUtils.hasText((String)vo.getExpenseCenter())) {
            vo.setExpenseCenter(this.findDictValueOrCode(vo.getExpenseCenter(), "tpm_expense_center"));
            Assert.hasText((String)vo.getExpenseCenter(), (String)"\u672a\u914d\u7f6e\u8be5\u8d39\u7528\u4e2d\u5fc3");
        }
        if (StringUtils.hasText((String)vo.getCustomerRetailerRegion()) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)vo.getCustomerRetailerRegion())) {
            vo.setCustomerRetailerRegion(this.findDictValueOrCode(vo.getCustomerRetailerRegion(), "MDM_CUSTOMIZE_ORG"));
            Assert.hasText((String)vo.getCustomerRetailerRegion(), (String)"\u672a\u914d\u7f6e\u8be5\u533a\u57df");
        }
    }

    private String findDictValueOrCode(String dictValue, String typeCode) {
        DictDataVo dictDataVo = this.dictMap.get(typeCode).stream().filter(a -> a.getDictValue().equals(dictValue) || a.getDictCode().equals(dictValue)).findFirst().orElse(null);
        if (!ObjectUtils.isEmpty((Object)dictDataVo)) {
            return dictDataVo.getDictCode();
        }
        return null;
    }

    public Integer getBatchCount() {
        return 1;
    }

    public Class<CostCenterRelationImportVo> findCrmExcelVoClass() {
        return CostCenterRelationImportVo.class;
    }

    public String getTemplateCode() {
        return "MDM_COST_CENTER_RELATION_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u6210\u672c\u4e2d\u5fc3-\u6620\u5c04\u5173\u7cfb\u5bfc\u5165";
    }

    public String getBusinessCode() {
        return "MDM_COST_CENTER_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u6210\u672c\u4e2d\u5fc3\u5bfc\u5165";
    }
}

