/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.cost.center.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.cost.center.local.entity.CostCenter;
import com.biz.crm.mdm.business.cost.center.local.mapper.CostCenterMapper;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterDto;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterProfitsSelectDto;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterSelectDto;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class CostCenterRepository
extends ServiceImpl<CostCenterMapper, CostCenter> {
    @Autowired(required=false)
    private CostCenterMapper costCenterMapper;

    public Page<CostCenterVo> findByConditions(Pageable pageable, CostCenterDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.costCenterMapper.findByConditions((Page<CostCenterVo>)page, dto);
    }

    public List<CommonSelectVo> findFormSelectList(CostCenterSelectDto dto) {
        return this.costCenterMapper.findFormSelectList(dto, 50);
    }

    public List<CommonSelectVo> findProfitsFormSelectList(CostCenterProfitsSelectDto dto) {
        return this.costCenterMapper.findProfitsFormSelectList(dto, 50);
    }

    public List<CostCenter> findByCostCenterCodes(List<String> costCenterCodeList) {
        if (CollectionUtils.isEmpty(costCenterCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(CostCenter::getCostCenterCode, costCenterCodeList)).list();
    }

    public List<CostCenterVo> findByCodeOrName(List<String> codeOrName) {
        Assert.notEmpty(codeOrName, (String)"\u7f16\u7801\u540d\u79f0\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        CostCenterDto dto = new CostCenterDto();
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setCodeOrNameList(codeOrName);
        return ((CostCenterMapper)this.baseMapper).findByCostCenterDto(dto);
    }
}

