/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.cost.center.local.service.internal;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.cost.center.local.entity.CostCenter;
import com.biz.crm.mdm.business.cost.center.local.repository.CostCenterRepository;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterDto;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterLogEventDto;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterProfitsSelectDto;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterSelectDto;
import com.biz.crm.mdm.business.cost.center.sdk.event.log.CostCenterEventListener;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.SapFiCostCenterDto;
import com.biz.crm.mn.third.system.sap.fi.sdk.service.SapFiService;
import com.biz.crm.mn.third.system.sap.fi.sdk.vo.SapFiCostCenterVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="CostCenterService")
public class CostCenterServiceImpl
implements CostCenterService {
    private static final Logger log = LoggerFactory.getLogger(CostCenterServiceImpl.class);
    @Autowired(required=false)
    private SapFiService sapFiService;
    @Autowired(required=false)
    private CostCenterRepository costCenterRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    public Page<CostCenterVo> findByConditions(Pageable pageable, CostCenterDto costCenterDto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(costCenterDto)) {
            costCenterDto = new CostCenterDto();
        }
        costCenterDto.setTenantCode(TenantUtils.getTenantCode());
        Page<CostCenterVo> page = this.costCenterRepository.findByConditions(pageable, costCenterDto);
        if (!CollectionUtils.isEmpty((Collection)page.getRecords())) {
            Map dictMap = this.dictToolkitService.findMapByDictTypeCode("tpm_profit_center");
            for (CostCenterVo vo : page.getRecords()) {
                if (!StringUtils.isNotBlank((CharSequence)vo.getProfitCenterCode()) || !dictMap.containsKey(vo.getProfitCenterCode())) continue;
                vo.setProfitCenterName((String)dictMap.get(vo.getProfitCenterCode()));
            }
        }
        return page;
    }

    public CostCenterVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        CostCenter costCenter = (CostCenter)((Object)this.costCenterRepository.getById((Serializable)((Object)id)));
        if (null == costCenter) {
            return null;
        }
        return (CostCenterVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)costCenter, CostCenterVo.class, null, null, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List entityList = this.costCenterRepository.listByIds(ids);
        ArrayList list = new ArrayList();
        entityList.forEach(item -> {
            CostCenter entity = new CostCenter();
            entity.setId(item.getId());
            entity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            entity.setCostCenterCode(entity.getCostCenterCode() + entity.getId());
            list.add(entity);
            CostCenterLogEventDto logEventDto = new CostCenterLogEventDto();
            CostCenterVo oldVo = (CostCenterVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, CostCenterVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            CostCenterDto newDto = (CostCenterDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, CostCenterDto.class, null, null, new String[0]);
            newDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            newDto.setCostCenterCode(entity.getCostCenterCode() + entity.getId());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onDelete = CostCenterEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostCenterEventListener.class, (SerializableBiConsumer)onDelete);
        });
        this.costCenterRepository.updateBatchById(list);
    }

    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List entityList = this.costCenterRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entityList) ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        ArrayList list = new ArrayList();
        entityList.forEach(item -> {
            CostCenter entity = new CostCenter();
            entity.setId(item.getId());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            list.add(entity);
            CostCenterLogEventDto logEventDto = new CostCenterLogEventDto();
            CostCenterVo oldVo = (CostCenterVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, CostCenterVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            CostCenterDto newDto = (CostCenterDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, CostCenterDto.class, null, null, new String[0]);
            newDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onEnable = CostCenterEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostCenterEventListener.class, (SerializableBiConsumer)onEnable);
        });
        this.costCenterRepository.updateBatchById(list);
    }

    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        List entityList = this.costCenterRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entityList) ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        ArrayList list = new ArrayList();
        entityList.forEach(item -> {
            CostCenter entity = new CostCenter();
            entity.setId(item.getId());
            entity.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            list.add(entity);
            CostCenterLogEventDto logEventDto = new CostCenterLogEventDto();
            CostCenterVo oldVo = (CostCenterVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, CostCenterVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            CostCenterDto newDto = (CostCenterDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, CostCenterDto.class, null, null, new String[0]);
            newDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onEnable = CostCenterEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostCenterEventListener.class, (SerializableBiConsumer)onEnable);
        });
        this.costCenterRepository.updateBatchById(list);
    }

    public List<CommonSelectVo> findFormSelectList(CostCenterSelectDto dto) {
        if (Objects.isNull(dto)) {
            dto = new CostCenterSelectDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.costCenterRepository.findFormSelectList(dto);
    }

    public List<CommonSelectVo> findProfitsFormSelectList(CostCenterProfitsSelectDto dto) {
        if (Objects.isNull(dto)) {
            dto = new CostCenterProfitsSelectDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<CommonSelectVo> list = this.costCenterRepository.findProfitsFormSelectList(dto);
        if (!CollectionUtils.isEmpty(list)) {
            Map map = this.dictToolkitService.findMapByDictTypeCode("tpm_profit_center");
            list.forEach(v -> v.setValue(map.getOrDefault(v.getCode(), v.getValue())));
        }
        return list;
    }

    public void pullCostCenterList(SapFiCostCenterDto dto) {
        List sapFiCostCenterVos = this.sapFiService.pullCostCenterList(dto);
        if (CollectionUtils.isEmpty((Collection)sapFiCostCenterVos)) {
            return;
        }
        Map<String, CostCenter> costCenterMap = this.sapCostCenterVoToMap(sapFiCostCenterVos);
        if (CollectionUtils.isEmpty(costCenterMap)) {
            return;
        }
        List<String> costCenterCodeList = costCenterMap.values().stream().map(CostCenter::getCostCenterCode).collect(Collectors.toList());
        List<CostCenter> byCodes = this.costCenterRepository.findByCostCenterCodes(costCenterCodeList);
        if (CollectionUtils.isEmpty(byCodes)) {
            this.saveOrUpdateBatch(new ArrayList<CostCenter>(costCenterMap.values()), null);
            return;
        }
        ArrayList<CostCenter> saveList = new ArrayList<CostCenter>();
        ArrayList<CostCenter> updateList = new ArrayList<CostCenter>();
        Map<String, CostCenter> oldMap = byCodes.stream().collect(Collectors.toMap(v -> v.getCostCenterCode() + StrUtil.nullToEmpty((CharSequence)v.getCompanyCode()) + StrUtil.nullToEmpty((CharSequence)v.getProfitCenterCode()), v -> v, (oldValue, newValue) -> newValue));
        costCenterMap.forEach((key, entity) -> {
            if (oldMap.containsKey(key)) {
                CostCenter oldEntity = (CostCenter)((Object)((Object)oldMap.get(key)));
                entity.setId(oldEntity.getId());
                entity.setCreateTime(oldEntity.getCreateTime());
                entity.setCreateName(oldEntity.getCreateName());
                entity.setCreateAccount(oldEntity.getCreateAccount());
                updateList.add((CostCenter)((Object)entity));
            } else {
                saveList.add((CostCenter)((Object)entity));
            }
        });
        this.saveOrUpdateBatch(saveList, updateList);
    }

    public CostCenterVo findByCode(String costCenterCode) {
        if (StringUtils.isBlank((CharSequence)costCenterCode)) {
            return null;
        }
        CostCenter costCenter = (CostCenter)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.costCenterRepository.lambdaQuery().eq(CostCenter::getCostCenterCode, (Object)costCenterCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
        if (null == costCenter) {
            return null;
        }
        return (CostCenterVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)costCenter, CostCenterVo.class, null, null, new String[0]);
    }

    private void saveOrUpdateBatch(List<CostCenter> saveList, List<CostCenter> updateList) {
        if (!CollectionUtils.isEmpty(saveList)) {
            this.costCenterRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.costCenterRepository.updateBatchById(updateList);
        }
    }

    private Map<String, CostCenter> sapCostCenterVoToMap(List<SapFiCostCenterVo> sapFiCostCenterVos) {
        if (CollectionUtils.isEmpty(sapFiCostCenterVos)) {
            return Collections.emptyMap();
        }
        HashMap<String, CostCenter> resultMap = new HashMap<String, CostCenter>(sapFiCostCenterVos.size());
        sapFiCostCenterVos.forEach(sapVo -> {
            sapVo.setKOSTL(StrUtil.nullToEmpty((CharSequence)sapVo.getKOSTL()));
            if (StringUtils.isEmpty((CharSequence)sapVo.getKOSTL())) {
                log.error("SAP\u6570\u636e\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u4e3a\u7a7a[{}]", (Object)sapFiCostCenterVos);
                return;
            }
            sapVo.setBUKRS(StrUtil.nullToEmpty((CharSequence)sapVo.getBUKRS()));
            sapVo.setPRCTR(StrUtil.nullToEmpty((CharSequence)sapVo.getPRCTR()));
            String key = sapVo.getKOSTL() + sapVo.getBUKRS() + sapVo.getPRCTR();
            CostCenter newEntity = this.getCostCenterForSapVo((SapFiCostCenterVo)sapVo);
            CostCenter entity = this.compareNewAndOldEntity(newEntity, (CostCenter)((Object)((Object)resultMap.get(key))));
            resultMap.put(key, entity);
        });
        return resultMap;
    }

    private CostCenter getCostCenterForSapVo(SapFiCostCenterVo sapVo) {
        CostCenter entity = new CostCenter();
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setCostCenterCode(sapVo.getKOSTL());
        entity.setCostCenterName(sapVo.getLTEXT());
        entity.setCompanyCode(sapVo.getBUKRS());
        entity.setProfitCenterCode(sapVo.getPRCTR());
        EnableStatusEnum enableStatusEnum = EnableStatusEnum.ENABLE;
        if (StringUtils.isNotBlank((CharSequence)sapVo.getBKZKP())) {
            enableStatusEnum = EnableStatusEnum.DISABLE;
        }
        entity.setProfitCenterName("default");
        if (StringUtils.isNotBlank((CharSequence)sapVo.getDATAB())) {
            try {
                entity.setBeginTime(DateUtil.date_yyyy_MM_dd.parse(sapVo.getDATAB()));
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sapVo.getDATBI())) {
            try {
                entity.setEndTime(DateUtil.date_yyyy_MM_dd.parse(sapVo.getDATBI()));
                if (Objects.nonNull(entity.getEndTime())) {
                    Date nowDate = new Date();
                    if (entity.getEndTime().compareTo(nowDate) < 0) {
                        enableStatusEnum = EnableStatusEnum.DISABLE;
                    }
                }
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        entity.setEnableStatus(enableStatusEnum.getCode());
        return entity;
    }

    private CostCenter compareNewAndOldEntity(CostCenter newEntity, CostCenter oldEntity) {
        if (Objects.isNull((Object)oldEntity)) {
            return newEntity;
        }
        if (EnableStatusEnum.ENABLE.getCode().equals(newEntity.getEnableStatus())) {
            return newEntity;
        }
        if (EnableStatusEnum.ENABLE.getCode().equals(oldEntity.getEnableStatus())) {
            return oldEntity;
        }
        if (Objects.nonNull(newEntity.getEndTime()) && Objects.nonNull(oldEntity.getEndTime())) {
            if (newEntity.getEndTime().compareTo(oldEntity.getEndTime()) > 0) {
                return newEntity;
            }
            return oldEntity;
        }
        if (Objects.nonNull(newEntity.getBeginTime()) && Objects.nonNull(oldEntity.getBeginTime())) {
            if (newEntity.getBeginTime().compareTo(oldEntity.getBeginTime()) > 0) {
                return newEntity;
            }
            return oldEntity;
        }
        return newEntity;
    }
}

