/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.cost.center.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.cost.center.local.entity.CostCenterRelation;
import com.biz.crm.mdm.business.cost.center.local.helper.ICostCenterRelationHelper;
import com.biz.crm.mdm.business.cost.center.local.repository.ICostCenterRelationRepository;
import com.biz.crm.mdm.business.cost.center.local.service.ICostCenterRelationService;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterRelationDto;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterRelationVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="iCostCenterRelationService")
public class ICostCenterRelationServiceImpl
implements ICostCenterRelationService {
    private static final Logger log = LoggerFactory.getLogger(ICostCenterRelationServiceImpl.class);
    @Resource
    private ICostCenterRelationRepository iCostCenterRelationRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Resource
    private ICostCenterRelationHelper iCostCenterRelationHelper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void create(CostCenterRelationDto dto) {
        this.iCostCenterRelationHelper.verifyEmpty(dto);
        String uniqueKey = this.iCostCenterRelationHelper.verifyUniqueness(dto);
        CostCenterRelation entity = (CostCenterRelation)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, CostCenterRelation.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setUniqueKey(uniqueKey);
        this.iCostCenterRelationRepository.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(CostCenterRelationDto dto) {
        Assert.hasText((String)dto.getId(), (String)"\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a");
        this.iCostCenterRelationHelper.verifyEmpty(dto);
        String uniqueKey = this.iCostCenterRelationHelper.verifyUniqueness(dto);
        CostCenterRelation entity = (CostCenterRelation)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, CostCenterRelation.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setUniqueKey(uniqueKey);
        this.iCostCenterRelationRepository.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u4fe1\u606f");
        this.iCostCenterRelationRepository.delete(ids);
    }

    @Override
    public CostCenterRelationVo findById(String id) {
        CostCenterRelation entity = (CostCenterRelation)((Object)this.iCostCenterRelationRepository.getById((Serializable)((Object)id)));
        return (CostCenterRelationVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, CostCenterRelationVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public List<CostCenterRelationVo> findByCondition(CostCenterRelationDto costCenterRelationDto) {
        if (Objects.isNull(costCenterRelationDto)) {
            return null;
        }
        List<CostCenterRelationVo> byCondition = this.iCostCenterRelationRepository.findByCondition(costCenterRelationDto);
        if (CollectionUtil.isNotEmpty(byCondition)) {
            Map dictMap = this.dictToolkitService.findMapByDictTypeCode("tpm_profit_center");
            for (CostCenterRelationVo vo : byCondition) {
                if (!StringUtils.isNotBlank((CharSequence)vo.getProfitCenterCode()) || !dictMap.containsKey(vo.getProfitCenterCode())) continue;
                vo.setProfitCenterName((String)dictMap.get(vo.getProfitCenterCode()));
            }
        }
        return byCondition;
    }
}

