/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.cost.center.local.service.internal;

import com.biz.crm.mdm.business.cost.center.local.repository.ICostCenterRelationRepository;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterWithholdingDetailDto;
import com.biz.crm.mdm.business.cost.center.sdk.service.ICostCenterRelationVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterRelationVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

@Service
public class ICostCenterRelationVoServiceImpl
implements ICostCenterRelationVoService {
    @Resource
    private ICostCenterRelationRepository iCostCenterRelationRepository;

    public Map<String, List<CostCenterRelationVo>> withholdingDetailMap(CostCenterWithholdingDetailDto dto) {
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e3a\u7a7a", (Object[])new Object[0]);
        List<CostCenterRelationVo> vos = this.iCostCenterRelationRepository.withholdingDetailMap(dto);
        HashMap<String, List<CostCenterRelationVo>> map = new HashMap<String, List<CostCenterRelationVo>>();
        Map<String, List<CostCenterRelationVo>> verticalMatchKeysMap = vos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCustomerRetailerRegion()) && StringUtils.isNotEmpty((CharSequence)e.getCustomerRetailerCode()) && StringUtils.isNotEmpty((CharSequence)e.getExpenseCenter())).collect(Collectors.groupingBy(e -> e.getCustomerRetailerRegion() + e.getCustomerRetailerCode() + e.getExpenseCenter()));
        Map<String, List<CostCenterRelationVo>> cusCostCenterKeysMap = vos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCustomerCode()) && StringUtils.isNotEmpty((CharSequence)e.getExpenseCenter())).collect(Collectors.groupingBy(e -> e.getCustomerCode() + e.getExpenseCenter()));
        Map<String, List<CostCenterRelationVo>> customerCodeKeysMap = vos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCustomerCode())).collect(Collectors.groupingBy(CostCenterRelationVo::getCustomerCode));
        Map<String, List<CostCenterRelationVo>> groupCodeKeysMap = vos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getSalesGroupCode())).collect(Collectors.groupingBy(CostCenterRelationVo::getSalesGroupCode));
        Map<String, List<CostCenterRelationVo>> departCodeKeysMap = vos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getSalesOrgCode())).collect(Collectors.groupingBy(CostCenterRelationVo::getSalesOrgCode));
        Map<String, List<CostCenterRelationVo>> institutionCodeKeysMap = vos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getSalesInstitutionCode())).collect(Collectors.groupingBy(CostCenterRelationVo::getSalesInstitutionCode));
        map.putAll(verticalMatchKeysMap);
        map.putAll(cusCostCenterKeysMap);
        map.putAll(customerCodeKeysMap);
        map.putAll(groupCodeKeysMap);
        map.putAll(departCodeKeysMap);
        map.putAll(institutionCodeKeysMap);
        return map;
    }
}

