package com.biz.crm.mdm.business.customer.channel.local.service;


import com.biz.crm.mdm.business.customer.channel.local.entity.CustomerChannel;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 客户渠道主表(CustomerChannel)表服务接口
 *
 * @author HanJiaJun
 * @since 2022-10-31 17:04:10
 */
public interface CustomerChannelService{

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param customerChannel 实体对象
   * @return
   */
  Page<CustomerChannel> findByConditions(Pageable pageable, CustomerChannel customerChannel);
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  CustomerChannel findById(String id);
  
   /**
   * 新增数据
   * @param customerChannel 实体对象
   * @return 新增结果
   */
  CustomerChannel create(CustomerChannel customerChannel);
  
   /**
   * 修改新据
   * @param customerChannel 实体对象
   * @return 修改结果
   */
  CustomerChannel update(CustomerChannel customerChannel);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 批量启用
   * @param idList
   */
  void enableBatch(List<String> idList);

  /**
   * 批量禁用
   * @param idList
   */
  void disableBatch(List<String> idList);

  /**
   * 通过编码查询
   * @param customerChannelCode
   */
  CustomerChannel findByCode(String customerChannelCode);
}

