/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.channel.local.service.internal;

import com.biz.crm.mdm.business.customer.channel.local.entity.ChannelClassificationEntity;
import com.biz.crm.mdm.business.customer.channel.local.repository.ChannelClassificationRepository;
import com.biz.crm.mdm.business.customer.channel.local.service.ChannelClassificationService;
import com.biz.crm.mdm.business.customer.channel.sdk.dto.ChannelClassificationDto;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.ChannelClassificationVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChannelClassificationServiceImpl
implements ChannelClassificationService {
    private static final Logger log = LoggerFactory.getLogger(ChannelClassificationServiceImpl.class);
    @Autowired(required=false)
    private ChannelClassificationRepository channelClassificationRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<ChannelClassificationVo> findChannelClassifications(ChannelClassificationDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getBelongType()) || StringUtils.isEmpty((CharSequence)dto.getChannelClassMinTypeCode())) {
            return Lists.newArrayList();
        }
        List<ChannelClassificationEntity> entities = this.channelClassificationRepository.findByConditions(dto);
        Collection channelClassificationVos = this.nebulaToolkitService.copyCollectionByBlankList(entities, ChannelClassificationEntity.class, ChannelClassificationVo.class, HashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<ChannelClassificationVo>(channelClassificationVos);
    }
}

