package com.biz.crm.mdm.business.customer.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.feign.feign.internal.CustomerVoFeignImpl;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Set;

/**
 * 客户feign接口类
 *
 * @author ning.zhang
 * @date 2022/2/18
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = CustomerVoFeignImpl.class)
public interface CustomerVoFeign {

  /**
   * 根据客户编码集合获取对应的客户信息
   *
   * @param customerCodeList 客户编码集合
   * @return 客户信息
   */
  @GetMapping("/v1/customer/customer/findByCustomerCodes")
  Result<List<CustomerVo>> findByCustomerCodes(@RequestParam("customerCodeList") List<String> customerCodeList);

  /**
   * 根据组织集合、渠道集合、标签集合查询客户编码集合
   *
   * @param orgCodes 组织集合
   * @param channels 渠道集合
   * @param tags 标签集合
   * @return 客户编码集合
   */
  @ApiOperation(value = "根据渠道编码集合获取对应的客户信息")
  @GetMapping("/v1/customer/customer/findCustomerCodesByOrgCodesAndChannelsAndTags")
  Result<Set<String>> findCustomerCodesByOrgCodesAndChannelsAndTags(@RequestParam(value = "orgCodes", required=false) List<String> orgCodes,
                                                                    @RequestParam(value = "channels", required=false) List<String> channels,
                                                                    @RequestParam(value = "tags", required=false) List<String> tags);

}
