package com.biz.crm.mdm.business.customer.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.feign.feign.CustomerClientVoServiceFeign;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerClientDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerClientVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerClientVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 经销商客户sdk实现
 *
 * @author songjingen
 */
@Service
public class CustomerClientVoServiceImpl implements CustomerClientVoService {

  @Autowired(required = false)
  private CustomerClientVoServiceFeign customerClientVoServiceFeign;

  @Override
  public Page<CustomerClientVo> findChildrenPageByCustomerClientDto(Pageable pageable, CustomerClientDto dto) {
    return this.customerClientVoServiceFeign.findChildrenPageByCustomerClientDto(pageable.getPageNumber(), pageable.getPageSize(), dto).getResult();
  }
}
