package com.biz.crm.mdm.business.customer.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.feign.feign.internal.CustomerAddressVoServiceFeignImpl;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerAddressQueryDto;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerAddressVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 客户收货地址feign
 *
 * @author sunx
 * @date 2021/11/15
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = CustomerAddressVoServiceFeignImpl.class)
public interface CustomerAddressVoServiceFeign {

  /**
   * 通过ID获取客户收货地址详细信息
   *
   * @param id 收货地址ID
   * @return 客户收货地址信息
   */
  @GetMapping("/v1/customerAddress/customerAddress/findDetailsById")
  Result<CustomerAddressVo> findDetailsById(
      @RequestParam(value = "id", required = false) String id);


  /**
   * 查询客户收货地址列表
   *
   * @param dto dto
   * @return {@link Result}<{@link List}<{@link CustomerAddressVo}>>
   */
  @GetMapping("/v1/customerAddress/customerAddress/findByCustomerAddressQueryDto")
  Result<List<CustomerAddressVo>> findByCustomerAddressQueryDto( @SpringQueryMap CustomerAddressQueryDto dto);
}
