package com.biz.crm.mdm.business.customer.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.feign.feign.CustomerAddressVoServiceFeign;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerAddressQueryDto;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerAddressVo;

import lombok.extern.slf4j.Slf4j;

import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 客户收货地址feign熔断实现
 *
 * @author sunx
 * @date 2021/11/15
 */
@Component
@Slf4j
public class CustomerAddressVoServiceFeignImpl
    implements FallbackFactory<CustomerAddressVoServiceFeign> {

  @Override
  public CustomerAddressVoServiceFeign create(Throwable throwable) {
    log.error("进入CustomerAddressVoServiceFeign熔断", throwable);
    return new CustomerAddressVoServiceFeign() {
      @Override
      public Result<CustomerAddressVo> findDetailsById(String id) {
        throw new UnsupportedOperationException("通过ID获取客户收货地址详细信息熔断");
      }

      @Override
      public Result<List<CustomerAddressVo>> findByCustomerAddressQueryDto(CustomerAddressQueryDto dto) {
        throw new UnsupportedOperationException("查询客户收货地址列表熔断");
      }
    };
  }
}
