package com.biz.crm.mdm.business.customer.feign.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.feign.feign.CustomerClientVoServiceFeign;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerClientDto;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerClientVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 客户feign熔断实现
 *
 * @author songjingen
 */
@Component
public class CustomerClientVoServiceFeignImpl implements FallbackFactory<CustomerClientVoServiceFeign> {

  @Override
  public CustomerClientVoServiceFeign create(Throwable throwable) {
    return new CustomerClientVoServiceFeign() {
      @Override
      public Result<Page<CustomerClientVo>> findChildrenPageByCustomerClientDto(@RequestParam("page") Integer page,
                                                                                @RequestParam("size") Integer size,
                                                                                @SpringQueryMap CustomerClientDto dto) {
        throw new UnsupportedOperationException("查询当前用户及其下属所关联的客户信息分页列表熔断");
      }
    };
  }
}
