package com.biz.crm.mdm.business.customer.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.feign.feign.CustomerVoServiceFeign;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerQueryDto;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 客户feign熔断实现
 *
 * @author sunx
 * @date 2021/11/15
 */
@Component
public class CustomerVoServiceFeignImpl implements FallbackFactory<CustomerVoServiceFeign> {

  @Override
  public CustomerVoServiceFeign create(Throwable throwable) {
    return new CustomerVoServiceFeign() {
      @Override
      public Result<CustomerVo> findDetailsByIdOrCode(String id, String customerCode) {
        throw new UnsupportedOperationException("通过客户ID或者客户编码查询客户信息详情熔断");
      }

      @Override
      public Result<List<CustomerVo>> findByOrgCodes(List<String> orgCodeList) {
        throw new UnsupportedOperationException("根据企业组织编码获取匹配的客户信息熔断");
      }

      @Override
      public Result<List<CustomerVo>> findByCustomerCodes(List<String> customerCodeList) {
        throw new UnsupportedOperationException("根据客户编码集合获取对应的客户信息熔断");
      }

      @Override
      public Result<List<CustomerVo>> findCustomerAndContactByCustomerCodes(List<String> customerCodeList) {
        throw new UnsupportedOperationException("根据客户编码集合获取对应的客户信息及联系人熔断");
      }

      @Override
      public Result<List<CustomerVo>> findForPriceByCustomerCodes(Set<String> customerCodeSet) {
        throw new UnsupportedOperationException("根据客户编码集合获取对应的客户信息-包含主信息+组织信息熔断");
      }

      @Override
      public Result<List<CustomerVo>> findByChannels(List<String> channelList) {
        throw new UnsupportedOperationException("根据渠道编码集合获取对应的客户信息熔断");
      }

      @Override
      public Result<List<CustomerVo>> findByTypes(List<String> typeList) {
        throw new UnsupportedOperationException("根据客户类型集合获取对应的客户信息熔断");
      }

      @Override
      public Result<Set<String>> findByCustomerQueryDto(CustomerQueryDto dto) {
        throw new UnsupportedOperationException("根据CustomerQueryDto获取对应的客户编码集合熔断");
      }

      @Override
      public Result<Map<String, Set<String>>> findAllowSaleCustomerByOrgCodes(
          Set<String> orgCodes) {
        throw new UnsupportedOperationException("根据组织获取组织及下级所有的审核通过且未删除的经销商信息熔断");
      }

      @Override
      public Result<List<CustomerVo>> findByAmapIds(Set<String> amapIds) {
        throw new UnsupportedOperationException("根据高德id集合获取对应的客户信息熔断");
      }

      @Override
      public Result<Boolean> existByCustomerCodeAndChannels(List<String> channelList, String customerCode) {
        throw new UnsupportedOperationException("判断是否存在渠道内的经销商信息熔断");
      }

      @Override
      public Result<Boolean> existByCustomerCode(String customerCode) {
        throw new UnsupportedOperationException("判断是否存在经销商信息熔断");
      }

      @Override
      public Result<Boolean> existByCustomer7OrgIn7OrgNotIn(String customerCode, List<String> orgCodeIn, List<String> orgCodeNotIn) {
        throw new UnsupportedOperationException("判断客户是否在组织内熔断");
      }
    };
  }
}
