package com.biz.crm.mdm.business.customer.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.feign.feign.CustomerVoFeign;
import com.biz.crm.mdm.business.customer.feign.feign.CustomerVoServiceFeign;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerQueryDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerSelectDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 客户sdk实现
 *
 * @author sunx
 * @date 2021/11/15
 */
@Service
public class CustomerVoServiceImpl implements CustomerVoService {

  @Autowired(required = false)
  private CustomerVoServiceFeign customerVoServiceFeign;

  @Autowired(required = false)
  private CustomerVoFeign customerVoFeign;

  @Override
  public CustomerVo findDetailsByIdOrCode(String id, String customerCode) {
    Result<CustomerVo> result = this.customerVoServiceFeign.findDetailsByIdOrCode(id, customerCode);
    return result.getResult();
  }

  @Override
  public Page<CustomerVo> findByCustomerSelectDto(Pageable pageable, CustomerSelectDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public List<CustomerVo> findByOrgCodes(List<String> orgCodeList) {
    return this.customerVoServiceFeign.findByOrgCodes(orgCodeList).getResult();
  }

  @Override
  public List<CustomerVo> findByCustomerCodes(List<String> customerCodeList) {
    return this.customerVoServiceFeign.findByCustomerCodes(customerCodeList).getResult();
  }

  @Override
  public List<CustomerVo> findCustomerAndContactByCustomerCodes(List<String> customerCodeList) {
    return this.customerVoServiceFeign.findCustomerAndContactByCustomerCodes(customerCodeList).getResult();
  }

  @Override
  public List<CustomerVo> findForPriceByCustomerCodes(Set<String> customerCodeSet) {
    return this.customerVoServiceFeign.findForPriceByCustomerCodes(customerCodeSet).getResult();
  }

  @Override
  public List<CustomerVo> findByChannels(List<String> channelList) {
    return this.customerVoServiceFeign.findByChannels(channelList).getResult();
  }

  @Override
  public List<CustomerVo> findByTypes(List<String> typeList) {
    return this.customerVoServiceFeign.findByTypes(typeList).getResult();
  }

  @Override
  public Set<String> findCustomerCodesByOrgCodesAndChannelsAndTags(List<String> orgCodes, List<String> channels, List<String> tags) {
    return this.customerVoFeign.findCustomerCodesByOrgCodesAndChannelsAndTags(orgCodes, channels, tags).getResult();
  }

  @Override
  public Set<String> findByCustomerQueryDto(CustomerQueryDto dto) {
    return this.customerVoServiceFeign.findByCustomerQueryDto(dto).getResult();
  }

  @Override
  public Map<String, Set<String>> findAllowSaleCustomerByOrgCodes(Set<String> orgCodes) {
    return this.customerVoServiceFeign.findAllowSaleCustomerByOrgCodes(orgCodes).getResult();
  }

  @Override
  public List<CustomerVo> findByAmapIds(Set<String> amapIds) {
    return this.customerVoServiceFeign.findByAmapIds(amapIds).getResult();
  }

  @Override
  public Boolean existByCustomerCodeAndChannels(List<String> channelList, String customerCode) {
    return this.customerVoServiceFeign.existByCustomerCodeAndChannels(channelList, customerCode).getResult();
  }

  @Override
  public Boolean existByCustomerCode(String customerCode) {
    return this.customerVoServiceFeign.existByCustomerCode(customerCode).getResult();
  }

  @Override
  public Boolean existByCustomer7OrgIn7OrgNotIn(String customerCode, List<String> orgCodeIn, List<String> orgCodeNotIn) {
    return this.customerVoServiceFeign.existByCustomer7OrgIn7OrgNotIn(customerCode, orgCodeIn, orgCodeNotIn).getResult();
  }
}
