package com.biz.crm.mdm.business.customer.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.feign.feign.internal.CustomerClientVoServiceFeignImpl;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerClientDto;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerClientVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 经销商客户feign
 *
 * @author songjingen
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = CustomerClientVoServiceFeignImpl.class)
public interface CustomerClientVoServiceFeign {

  /**
   * 查询当前用户及其下属所关联的客户信息分页列表
   * <p>
   * 用户账号和租户必传
   *
   * @param dto  查询对象
   * @param page 页码
   * @param size 数量
   * @return Page<CustomerClientVo> 查询当前用户及其下属所关联的客户信息分页列表
   */
  @GetMapping("/v1/customer/customerClientVo/findChildrenPageByCustomerClientDto")
  Result<Page<CustomerClientVo>> findChildrenPageByCustomerClientDto(@RequestParam("page") Integer page,
                                                                     @RequestParam("size") Integer size,
                                                                     @SpringQueryMap CustomerClientDto dto);

}
