package com.biz.crm.mdm.business.customer.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.feign.feign.CustomerAddressVoServiceFeign;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerAddressPageDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerAddressQueryDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerAddressVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerAddressVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 客户收货地址信息VO服务接口类实现
 *
 * @author sunx
 * @date 2021/11/15
 */
@Service
public class CustomerAddressVoServiceImpl implements CustomerAddressVoService {

  @Autowired(required = false) private CustomerAddressVoServiceFeign customerAddressVoServiceFeign;

  @Override
  public Page<CustomerAddressVo> findByConditions(Pageable pageable, CustomerAddressPageDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public CustomerAddressVo findDetailsById(String id) {
    Result<CustomerAddressVo> result = customerAddressVoServiceFeign.findDetailsById(id);
    return result.checkFeignResult();
  }

  @Override
  public List<CustomerAddressVo> findByCustomerAddressQueryDto(CustomerAddressQueryDto dto) {
    Result<List<CustomerAddressVo>> result = customerAddressVoServiceFeign.findByCustomerAddressQueryDto(dto);
    return result.checkFeignResult();
  }
}
