package com.biz.crm.mdm.business.customer.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.feign.feign.CustomerVoFeign;
import com.biz.crm.mdm.business.customer.feign.feign.CustomerVoServiceFeign;
import com.biz.crm.mdm.business.customer.sdk.dto.*;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerRelateOrgVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 客户sdk实现
 *
 * @author sunx
 * @date 2021/11/15
 */
@Service
public class CustomerVoServiceImpl implements CustomerVoService {

  @Autowired(required = false)
  private CustomerVoServiceFeign customerVoServiceFeign;

  @Autowired(required = false)
  private CustomerVoFeign customerVoFeign;

  @Override
  public CustomerVo findDetailsByIdOrCode(String id, String customerCode) {
    Result<CustomerVo> result = this.customerVoServiceFeign.findDetailsByIdOrCode(id, customerCode);
    return result.checkFeignResult();
  }

  @Override
  public Page<CustomerVo> findByCustomerSelectDto(Pageable pageable, CustomerSelectDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public Page<CustomerVo> findByConditions(Pageable pageable, CustomerDto dto) {
    return this.customerVoServiceFeign.findByCustomerDto(pageable.getPageNumber(), pageable.getPageSize(), dto).checkFeignResult();
  }

  @Override
  public void modifyShareBenefits(List<String> customerCodeList, Boolean bool){
    CustomerDto dto = new CustomerDto();
    dto.setCustomerCodeList(customerCodeList);
    dto.setShareBenefits(bool);
    this.customerVoServiceFeign.modifyShareBenefits(dto);
  }

  @Override
  public List<CustomerVo> findByOrgCodes(List<String> orgCodeList) {
    return this.customerVoServiceFeign.findByOrgCodes(orgCodeList).checkFeignResult();
  }

  @Override
  public List<CustomerVo> findByCustomerCodes(List<String> customerCodeList) {
    return this.customerVoServiceFeign.findByCustomerCodes(customerCodeList).checkFeignResult();
  }

  @Override
  public List<CustomerVo> findCustomerAndContactByCustomerCodes(List<String> customerCodeList) {
    return this.customerVoServiceFeign.findCustomerAndContactByCustomerCodes(customerCodeList).checkFeignResult();
  }

  @Override
  public List<CustomerVo> findForPriceByCustomerCodes(Set<String> customerCodeSet) {
    return this.customerVoServiceFeign.findForPriceByCustomerCodes(customerCodeSet).checkFeignResult();
  }

  @Override
  public List<CustomerVo> findByChannels(List<String> channelList) {
    return this.customerVoServiceFeign.findByChannels(channelList).checkFeignResult();
  }

  @Override
  public List<CustomerVo> findByTypes(List<String> typeList) {
    return this.customerVoServiceFeign.findByTypes(typeList).checkFeignResult();
  }

  @Override
  public Set<String> findCustomerCodesByOrgCodesAndChannelsAndTags(List<String> orgCodes, List<String> channels, List<String> tags) {
    return this.customerVoFeign.findCustomerCodesByOrgCodesAndChannelsAndTags(orgCodes, channels, tags).checkFeignResult();
  }

  @Override
  public Set<String> findByCustomerQueryDto(CustomerQueryDto dto) {
    return this.customerVoServiceFeign.findByCustomerQueryDto(dto).checkFeignResult();
  }

  @Override
  public Map<String, Set<String>> findAllowSaleCustomerByOrgCodes(Set<String> orgCodes) {
    return this.customerVoServiceFeign.findAllowSaleCustomerByOrgCodes(orgCodes).checkFeignResult();
  }

  @Override
  public List<CustomerVo> findByAmapIds(Set<String> amapIds) {
    return this.customerVoServiceFeign.findByAmapIds(amapIds).checkFeignResult();
  }

  @Override
  public Boolean existByCustomerCodeAndChannels(List<String> channelList, String customerCode) {
    return this.customerVoServiceFeign.existByCustomerCodeAndChannels(channelList, customerCode).checkFeignResult();
  }

  @Override
  public Boolean existByCustomerCode(String customerCode) {
    return this.customerVoServiceFeign.existByCustomerCode(customerCode).checkFeignResult();
  }

  @Override
  public Boolean existByCustomer7OrgIn7OrgNotIn(String customerCode, List<String> orgCodeIn, List<String> orgCodeNotIn) {
    return this.customerVoServiceFeign.existByCustomer7OrgIn7OrgNotIn(customerCode, orgCodeIn, orgCodeNotIn).checkFeignResult();
  }

  @Override
  public CustomerVo findOrgByCode(String customerCode) {
    return this.customerVoServiceFeign.findOrgByCode(customerCode).checkFeignResult();
  }

  @Override
  public List<CustomerRelateOrgVo> findAllOrgByCode(String customerCode) {
    return this.customerVoServiceFeign.findAllOrgByCode(customerCode).checkFeignResult();
  }

  @Override
  public List<CustomerVo> findDetailsByIds(CustomerSearchDto dto) {
    return this.customerVoServiceFeign.findDetailsByIds(dto).checkFeignResult();
  }

  @Override
  public CustomerVo findBySourcesId(CustomerSourceIdDto dto) {
    return this.customerVoServiceFeign.findBySourcesId(dto).checkFeignResult();
  }
}
