package com.biz.crm.mdm.business.customer.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.local.entity.CustomerTagEntity;
import com.biz.crm.mdm.business.customer.local.service.CustomerTagService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerTagDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 客户信息: customerTag: 客户标签管理
 *
 * @author ning.zhang
 * @date 2021-10-28 17:48:59
 */
@Slf4j
@Api(tags = "客户信息: customerTag: 客户标签管理")
@RestController
@RequestMapping(value = {"/v1/customerTag/customerTag"})
public class CustomerTagController {

  @Autowired(required = false)
  private CustomerTagService customerTagService;

  /**
   * 新增客户标签
   * @param dto
   * @return
   */
  @ApiOperation(value = "新增客户标签")
  @PostMapping(value = "/create")
  public Result<CustomerTagEntity> create(@RequestBody CustomerTagDto dto) {
    try {
      return Result.ok(this.customerTagService.create(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新客户标签
   * @param dto
   * @return
   */
  @ApiOperation(value = "更新客户标签")
  @PatchMapping(value = "")
  public Result<CustomerTagEntity> update(@RequestBody CustomerTagDto dto) {
    try {
      return Result.ok(this.customerTagService.update(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteBatch")
  public Result<?> deleteBatch(@RequestParam("ids") List<String> ids) {
    try {
      this.customerTagService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量启用
   * @param ids
   * @return
   */
  @ApiOperation(value = "批量启用")
  @PatchMapping("/enableBatch")
  public Result enableBatch(@RequestBody List<String> ids) {
    try {
      this.customerTagService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量禁用
   * @param ids
   * @return
   */
  @ApiOperation(value = "批量禁用")
  @PatchMapping("/disableBatch")
  public Result disableBatch(@RequestBody List<String> ids) {
    try {
      this.customerTagService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查看详情（包括关联信息）
   * @param id
   * @return
   */
  @ApiOperation(value = "查看详情（包括关联信息）")
  @GetMapping("/findDetailById")
  public Result<CustomerTagEntity> findDetailById(@RequestParam(value = "id") @ApiParam(name = "id", value = "主键") String id) {
    try {
      return Result.ok(customerTagService.findDetailById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  @ApiOperation(value = "通过客户编码查询客户标签列表")
  @GetMapping("/findByCustomerCode")
  public Result<?> findByCustomerCode(@RequestParam(value = "customerCode") @ApiParam(name = "customerCode", value = "客户编码") String customerCode) {
    try {
      return Result.ok(customerTagService.findByCustomerCode(customerCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 调用经销商标签定时任务
   * @return
   */
  @ApiOperation(value = "调用经销商标签定时任务")
  @GetMapping("/handleCustomerTagTask")
  public Result<?> handleCustomerTagTask() {
    try {
      this.customerTagService.handleCustomerTagTask();
      return Result.ok("执行成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
