package com.biz.crm.mdm.business.customer.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.WorkflowFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 客户实体类
 *
 * @author ning.zhang
 * @date 2021/10/25
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerEntity", description = "客户实体")
@Entity
@TableName("mdm_customer")
@Table(
    name = "mdm_customer",
    indexes = {
      @Index(name = "mdm_customer_index1", columnList = "customer_code"),
      @Index(name = "mdm_customer_index2", columnList = "tenant_code,customer_code", unique = true),
    })
@org.hibernate.annotations.Table(appliesTo = "mdm_customer", comment = "客户表")
public class CustomerEntity extends WorkflowFlagOpEntity {

  private static final long serialVersionUID = -2379135367765734248L;

  /** 高德地图ID */
  @ApiModelProperty("高德地图ID")
  @Column(name = "amap_id", length = 64, columnDefinition = "VARCHAR(64) COMMENT '高德地图ID'")
  private String amapId;

  /** 渠道 */
  @ApiModelProperty("渠道")
  @Column(name = "channel", length = 64, columnDefinition = "VARCHAR(64) COMMENT '渠道'")
  private String channel;

  /** 客户编码 */
  @ApiModelProperty("客户编码")
  @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码'")
  private String customerCode;

  /** 客户组织编码 */
  @ApiModelProperty("客户组织编码")
  @Column(
      name = "customer_org_code",
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT '客户组织编码'")
  private String customerOrgCode;

  /** 客户名称 */
  @ApiModelProperty("客户名称")
  @Column(name = "customer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
  private String customerName;

  /** 客户类型 */
  @ApiModelProperty("客户类型")
  @Column(name = "customer_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户类型'")
  private String customerType;

  /** 操作类型 */
  @ApiModelProperty("操作类型")
  @Column(name = "operate_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '操作类型'")
  private String operateType;

  /** 市编码 */
  @ApiModelProperty("市编码")
  @Column(name = "city_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '市编码'")
  private String cityCode;

  /** 区编码 */
  @ApiModelProperty("区编码")
  @Column(name = "district_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '区编码'")
  private String districtCode;

  /** 省编码 */
  @ApiModelProperty("省编码")
  @Column(name = "province_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '省编码'")
  private String provinceCode;

  /** 注册地址 */
  @ApiModelProperty("注册地址")
  @Column(
      name = "registered_address",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '注册地址'")
  private String registeredAddress;

  /** 工程名 */
  @ApiModelProperty("工程名")
  @Column(name = "project_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '工程名'")
  private String projectName;

  /** 客户联系方式 */
  @ApiModelProperty("客户联系方式")
  @Column(
      name = "customer_contact",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '客户联系方式'")
  private String customerContact;

  /** 客户法人代表 */
  @ApiModelProperty("客户法人代表")
  @Column(
      name = "legal_representative",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '客户法人代表'")
  private String legalRepresentative;

  /** 锁定状态：009正常，003冻结 */
  @ApiModelProperty("锁定状态：009正常，003冻结")
  @Column(
      name = "lock_state",
      length = 8,
      columnDefinition = "VARCHAR(8) COMMENT '锁定状态：009正常，003冻结'")
  private String lockState;

  /** 经度 */
  @ApiModelProperty("经度")
  @Column(name = "longitude", columnDefinition = "decimal(12,8) COMMENT '经度'")
  private BigDecimal longitude;

  /** 纬度 */
  @ApiModelProperty("纬度")
  @Column(name = "latitude", columnDefinition = "decimal(12,8) COMMENT '纬度'")
  private BigDecimal latitude;

  /** erp编码 */
  @ApiModelProperty("erp编码")
  @Column(name = "erp_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'erp编码'")
  private String erpCode;

  /** 审批状态 */
  @ApiModelProperty("审批状态")
  @Column(name = "act_approve_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '审批状态'")
  private String actApproveStatus;

  /** 价格组 */
  @ApiModelProperty("价格组")
  @Column(name = "price_group", length = 64, columnDefinition = "VARCHAR(64) COMMENT '价格组'")
  private String priceGroup;

  /** 合作状态 */
  @ApiModelProperty("合作状态")
  @Column(name = "cooperate_status", length = 64, columnDefinition = "VARCHAR(64) COMMENT '合作状态'")
  private String cooperateStatus;

  /** 审批类型 */
  @ApiModelProperty("审批类型")
  @Column(name = "approval_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '审批类型'")
  private String approvalType;

  /** 流程编号 */
  @ApiModelProperty("流程编号")
  @Column(name = "process_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '流程编号'")
  private String processCode;

  /** 数据来源 */
  @ApiModelProperty("数据来源")
  @Column(name = "source_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据来源'")
  private String sourceType;

  /** 业务来源系统 */
  @ApiModelProperty("业务来源系统")
  @Column(name = "from_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务来源系统'")
  private String fromType;

  /** 关联对接人信息 */
  @ApiModelProperty("关联对接人信息")
  @Transient
  @TableField(exist = false)
  private List<CustomerDockingEntity> dockingList;

  /** 关联联系人信息 */
  @ApiModelProperty("关联联系人信息")
  @Transient
  @TableField(exist = false)
  private List<CustomerContactEntity> contactList;

  /** 关联销售区域信息 */
  @ApiModelProperty("关联销售区域信息")
  @Transient
  @TableField(exist = false)
  private List<CustomerSaleAreaEntity> saleAreaList;

  /** 关联开票信息 */
  @ApiModelProperty("关联开票信息")
  @Transient
  @TableField(exist = false)
  private List<CustomerBillEntity> billList;

  /** 关联文件信息(证件上传照片/法人身份上传照片) */
  @ApiModelProperty("关联文件信息(证件上传照片/法人身份上传照片)")
  @Transient
  @TableField(exist = false)
  private List<CustomerMediaEntity> fileList;

  /** 组织编码-占位 */
  @ApiModelProperty("组织编码-占位")
  @Transient
  @TableField(exist = false)
  private String orgCode;

  /** 客户与企业组织关联信息 */
  @ApiModelProperty("客户与企业组织关联信息")
  @Transient
  @TableField(exist = false)
  private List<CustomerROrgEntity> orgList;

  /** 客户等级 */
  @ApiModelProperty("客户等级")
  @Column(name = "customer_level", length = 10, columnDefinition = "VARCHAR(10) COMMENT '客户等级'")
  private String customerLevel;

  /** 上级经销商编码 */
  @ApiModelProperty("上级经销商编码")
  @Column(
      name = "parent_customer_code",
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT '上级经销商编码'")
  private String parentCustomerCode;
}
