package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.customer.local.entity.CustomerContactEntity;
import com.biz.crm.mdm.business.customer.local.mapper.CustomerContactMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 客户联系人信息表的数据库访问类 {@link CustomerContactEntity}
 *
 * @author ning.zhang
 * @date 2021-10-26 16:23:48
 */
@Component
public class CustomerContactRepository extends ServiceImpl<CustomerContactMapper, CustomerContactEntity> {

  /**
   * 通过客户编码删除客户联系人信息
   *
   * @param customerCode 客户编码
   * @param tenantCode   租户编码
   */
  public void deleteByCustomerCode(String customerCode, String tenantCode) {
    this.lambdaUpdate()
        .eq(CustomerContactEntity::getTenantCode, tenantCode)
        .eq(CustomerContactEntity::getCustomerCode, customerCode)
        .remove();
  }

  /**
   * 通过客户编码集合获取联系人列表
   *
   * @param customerCodes 客户编码集合
   * @param tenantCode   租户编码
   * @return 对接人列表
   */
  public List<CustomerContactEntity> findByCustomerCodes(List<String> customerCodes, String tenantCode) {
    return this.lambdaQuery()
        .eq(CustomerContactEntity::getTenantCode, tenantCode)
        .in(CustomerContactEntity::getCustomerCode, customerCodes)
        .list();
  }
}
