package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.customer.local.entity.CustomerSaleAreaEntity;
import com.biz.crm.mdm.business.customer.local.mapper.CustomerSaleAreaMapper;
import org.springframework.stereotype.Component;

/**
 * 客户销售区域表的数据库访问类 {@link CustomerSaleAreaEntity}
 *
 * @author ning.zhang
 * @date 2021-10-26 16:27:00
 */
@Component
public class CustomerSaleAreaRepository extends ServiceImpl<CustomerSaleAreaMapper, CustomerSaleAreaEntity> {

  /**
   * 通过客户编码删除客户销售区域
   *
   * @param customerCode 客户编码
   * @param tenantCode   租户编码
   */
  public void deleteByCustomerCode(String customerCode, String tenantCode) {
    this.lambdaUpdate()
        .eq(CustomerSaleAreaEntity::getTenantCode, tenantCode)
        .eq(CustomerSaleAreaEntity::getCustomerCode, customerCode)
        .remove();
  }
}
