package com.biz.crm.mdm.business.customer.local.service.internal;

import com.biz.crm.mdm.business.customer.local.entity.CustomerContactEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerContactRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerContactService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerContactDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 客户联系人信息表服务实现类
 *
 * @author ning.zhang
 * @date 2021-10-26 16:23:48
 */
@Service("customerContactService")
public class CustomerContactServiceImpl implements CustomerContactService {

  @Autowired(required = false)
  private CustomerContactRepository customerContactRepository;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void rebindCustomerCode(List<CustomerContactDto> dtoList, String customerCode) {
    Validate.notBlank(customerCode, "客户编码不能为空");
    String tenantCode = TenantUtils.getTenantCode();
    this.customerContactRepository.deleteByCustomerCode(customerCode, tenantCode);
    if (CollectionUtils.isEmpty(dtoList)) {
      return;
    }
    //过滤联系人姓名为空的数据
    List<CustomerContactEntity> entities = dtoList.stream()
        .filter(dto -> Objects.nonNull(dto) && StringUtils.isNotEmpty(dto.getContactName()))
        .map(dto -> {
          CustomerContactEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(dto, CustomerContactEntity.class, HashSet.class, ArrayList.class);
          //主联系人标识为空表示非主联系人
          entity.setContactMain(Objects.isNull(entity.getContactMain()) ? Boolean.FALSE : entity.getContactMain());
          entity.setCustomerCode(customerCode);
          entity.setTenantCode(tenantCode);
          return entity;
        }).collect(Collectors.toList());
    if (CollectionUtils.isEmpty(entities)) {
      return;
    }
    long count = entities.stream().filter(CustomerContactEntity::getContactMain).count();
    Validate.isTrue(count <= 1, "客户信息：主联系人只能有一个");
    Validate.isTrue(count == 1, "客户信息：主联系人必须有一个");
    this.customerContactRepository.saveBatch(entities);
  }


}
