package com.biz.crm.mdm.business.customer.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.local.entity.CustomerTagEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerTagRepository;
import com.biz.crm.mdm.business.customer.local.repository.CustomerTagVoRepository;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerTagDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerTagVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerTagVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 经销商标签接口实现
 * @Author: zengxingwang
 * @Date: 2021/12/21 19:30
 */
@Service
public class CustomerTagVoServiceImpl implements CustomerTagVoService {

  @Autowired(required = false)
  private CustomerTagVoRepository customerTagVoRepository;
  @Autowired(required = false)
  private CustomerTagRepository customerTagRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  /**
   * 多条件分页查询
   * @param pageable
   * @param customerTagDto
   * @return
   */
  @Override
  public Page<CustomerTagVo> findByConditions(Pageable pageable, CustomerTagDto customerTagDto) {
    customerTagDto = ObjectUtils.defaultIfNull(customerTagDto, new CustomerTagDto());
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    customerTagDto.setTenantCode(TenantUtils.getTenantCode());
    return customerTagVoRepository.findByConditions(pageable, customerTagDto);
  }

  @Override
  public List<CustomerTagVo> findByCustomerCodes(List<String> customerCodes) {
    if (CollectionUtils.isEmpty(customerCodes)) {
      return Lists.newLinkedList();
    }
    return this.customerTagVoRepository.findByCustomerCodes(customerCodes);
  }
}
