package com.biz.crm.mdm.business.customer.local.service.notifier;

import com.biz.crm.mdm.business.customer.local.entity.CustomerEntity;
import com.biz.crm.mdm.business.customer.local.model.MultipleConditionModel;
import com.biz.crm.mdm.business.customer.local.service.CustomerService;
import com.biz.crm.mdm.business.customer.org.sdk.event.CustomerOrgEventListener;
import com.biz.crm.mdm.business.customer.org.sdk.vo.CustomerOrgVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 客户信息客户组织事件监听实现
 *
 * @author ning.zhang
 * @date 2021/11/12
 */
@Component
public class CusCustomerOrgEventListener implements CustomerOrgEventListener {

  @Autowired(required = false)
  private CustomerService customerService;

  @Override
  public void onBatchCreate(List<CustomerOrgVo> customerOrgVos) {
    //do nothing
  }

  @Override
  public void onBatchUpdate(List<CustomerOrgVo> customerOrgVos) {
    //do nothing
  }

  @Override
  public void onBatchDisable(List<CustomerOrgVo> customerOrgVos) {
    //do nothing
  }

  @Override
  public void onBatchEnable(List<CustomerOrgVo> customerOrgVos) {
    //do nothing
  }

  /**
   * 当客户组织发生删除事件时，根据触发事件的客户组织编码,验证客户组织是否存在与客户的关联关系。
   * <p>
   * 1.存在与客户的关联关系,则抛出组织已关联客户的异常,阻断当前客户组织的删除操作
   * 2.不存在与客户的关联关系,则什么也不做.
   */
  @Override
  public void onBatchDelete(List<CustomerOrgVo> eventDtos) {
    if (CollectionUtils.isEmpty(eventDtos)) {
      return;
    }
    List<String> customerOrgCodes = eventDtos.stream().map(CustomerOrgVo::getCustomerOrgCode).collect(Collectors.toList());
    MultipleConditionModel model = new MultipleConditionModel();
    model.setCustomerOrgCodes(customerOrgCodes);
    List<CustomerEntity> list = customerService.findByMultipleConditionModel(model);
    Validate.isTrue(CollectionUtils.isEmpty(list), "存在与客户的绑定关系不能删除");
  }
}
