package com.biz.crm.mdm.business.customer.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 客户开票信息实体类
 *
 * @author ning.zhang
 * @date 2021/10/26
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerBillEntity", description = "客户开票信息实体类")
@Entity
@TableName("mdm_customer_bill")
@Table(name = "mdm_customer_bill", indexes = {
    @Index(name = "mdm_customer_bill_index1", columnList = "customer_code"),
    @Index(name = "mdm_customer_bill_index2", columnList = "tenant_code")
})
@org.hibernate.annotations.Table(appliesTo = "mdm_customer_bill", comment = "客户开票信息实表")
public class CustomerBillEntity extends TenantOpEntity {

  private static final long serialVersionUID = -2139965609927260258L;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码'")
  private String customerCode;

  /**
   * 开票单位
   */
  @ApiModelProperty("开票单位")
  @Column(name = "bill_company", length = 64, columnDefinition = "VARCHAR(64) COMMENT '开票单位'")
  private String billCompany;

  /**
   * 税号
   */
  @ApiModelProperty("税号")
  @Column(name = "tax_number", length = 64, columnDefinition = "VARCHAR(64) COMMENT '税号'")
  private String taxNumber;

  /**
   * 法人
   */
  @ApiModelProperty("法人")
  @Column(name = "legal", length = 64, columnDefinition = "VARCHAR(64) COMMENT '法人'")
  private String legal;

  /**
   * 开户银行
   */
  @ApiModelProperty("开户银行")
  @Column(name = "deposit_bank", length = 128, columnDefinition = "VARCHAR(128) COMMENT '开户银行'")
  private String depositBank;

  /**
   * 银行帐号
   */
  @ApiModelProperty("银行帐号")
  @Column(name = "bank_account", length = 64, columnDefinition = "VARCHAR(64) COMMENT '银行帐号'")
  private String bankAccount;

  /**
   * 是否是默认开票信息(true:是,false:否)
   */
  @ApiModelProperty("是否是默认开票信息(true:是,false:否)")
  @Column(name = "bill_main", columnDefinition = "int(1) COMMENT '是否是默认开票信息，1是0否'")
  private Boolean billMain;

}
