package com.biz.crm.mdm.business.customer.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 客户媒体文件实体
 *
 * @author ning.zhang
 * @date 2021/10/26
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerMediaEntity", description = "客户媒体文件实体")
@Entity
@TableName("mdm_customer_media")
@Table(name = "mdm_customer_media", indexes = {
    @Index(name = "mdm_customer_media_index1", columnList = "customer_code"),
    @Index(name = "mdm_customer_media_index2", columnList = "tenant_code"),
})
@org.hibernate.annotations.Table(appliesTo = "mdm_customer_media", comment = "客户媒体文件表")
public class CustomerMediaEntity extends FileEntity {

  private static final long serialVersionUID = 441326099215679433L;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码'")
  private String customerCode;

  /**
   * 文件类型(1:企业证书照片,2:法人身份证照片)
   */
  @ApiModelProperty("文件类型(1:企业证书照片,2:法人身份证照片)")
  @Column(name = "file_type", length = 12, columnDefinition = "VARCHAR(12) COMMENT '文件类型(1:企业证书照片,2:法人身份证照片)'")
  private String fileType;
}
