package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.customer.local.entity.CustomerDockingEntity;
import com.biz.crm.mdm.business.customer.local.mapper.CustomerDockingMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 客户对接人表的数据库访问类 {@link CustomerDockingEntity}
 *
 * @author ning.zhang
 * @date 2021-10-26 16:25:01
 */
@Component
public class CustomerDockingRepository extends ServiceImpl<CustomerDockingMapper, CustomerDockingEntity> {

  /**
   * 通过客户编码获取对接人列表
   *
   * @param customerCode 客户编码
   * @param tenantCode   租户编码
   * @return 对接人列表
   */
  public List<CustomerDockingEntity> findByCustomerCode(String customerCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(CustomerDockingEntity::getTenantCode, tenantCode)
        .eq(CustomerDockingEntity::getCustomerCode, customerCode)
        .list();
  }

  /**
   * 通过客户编码集合和职位编码获取对接人列表
   *
   * @param customerCodes 客户编码集合
   * @param positionCode 职位编码
   * @param tenantCode   租户编码
   * @return 对接人列表
   */
  public List<CustomerDockingEntity> findByCustomerCodesAndPositionCode(List<String> customerCodes, String positionCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(CustomerDockingEntity::getTenantCode, tenantCode)
        .in(CustomerDockingEntity::getCustomerCode, customerCodes)
        .eq(CustomerDockingEntity::getPositionCode, positionCode)
        .list();
  }

  /**
   * 通过客户编码集合获取对接人列表
   *
   * @param customerCodes 客户编码集合
   * @param tenantCode   租户编码
   * @return 对接人列表
   */
  public List<CustomerDockingEntity> findByCustomerCodes(List<String> customerCodes, String tenantCode) {
    return this.lambdaQuery()
        .eq(CustomerDockingEntity::getTenantCode, tenantCode)
        .in(CustomerDockingEntity::getCustomerCode, customerCodes)
        .list();
  }
}
