package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.customer.local.entity.CustomerDockingSupplyEntity;
import com.biz.crm.mdm.business.customer.local.mapper.CustomerDockingSupplyMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 客户对接人供货信息表的数据库访问类 {@link CustomerDockingSupplyEntity}
 *
 * @author ning.zhang
 * @date 2021-10-26 16:25:42
 */
@Component
public class CustomerDockingSupplyRepository extends ServiceImpl<CustomerDockingSupplyMapper, CustomerDockingSupplyEntity> {

  /**
   * 通过对接人ID集合删除客户对接人供货信息
   *
   * @param dockingIds 对接人ID集合
   */
  public void deleteByDockingIds(List<String> dockingIds) {
    this.lambdaUpdate()
        .in(CustomerDockingSupplyEntity::getDockingId, dockingIds)
        .remove();
  }
}
