package com.biz.crm.mdm.business.customer.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.local.entity.CustomerAddressEntity;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerAddressDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerAddressPageDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 客户收货地址表服务接口
 *
 * @author ning.zhang
 * @date 2021-10-28 17:48:58
 */
public interface CustomerAddressService {

  /**
   * 创建客户收货地址
   *
   * @param dto 参数dto
   * @return 创建的客户收货地址
   */
  CustomerAddressEntity create(CustomerAddressDto dto);

  /**
   * 更新客户收货地址
   *
   * @param dto 参数dto
   * @return 更新的客户收货地址
   */
  CustomerAddressEntity update(CustomerAddressDto dto);

  /**
   * 批量删除客户收货地址
   *
   * @param ids 客户收货地址id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 客户收货地址分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CustomerAddressEntity> 客户收货地址分页信息
   */
  Page<CustomerAddressEntity> findByConditions(Pageable pageable, CustomerAddressPageDto dto);

  /**
   * 通过ID获取客户收货地址信息
   * @param id 收货地址ID
   * @return 客户收货地址信息
   */
  CustomerAddressEntity findById(String id);
}
