package com.biz.crm.mdm.business.customer.local.service.internal;

import com.biz.crm.mdm.business.customer.local.entity.CustomerTagRuleEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerTagRuleRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerTagRuleService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;

/**
 * 经销商标签规则接口实现
 * @Author: zengxingwang
 * @Date: 2021/12/21 16:13
 */
@Service
public class CustomerTagRuleServiceImpl implements CustomerTagRuleService {

  @Autowired(required = false)
  private CustomerTagRuleRepository customerTagRuleRepository;
  /**
   * 创建规则
   * @param customerTagRuleEntities
   */
  @Override
  public void create(Collection<CustomerTagRuleEntity> customerTagRuleEntities) {
    this.createValidate(customerTagRuleEntities);
    this.customerTagRuleRepository.saveBatch(customerTagRuleEntities);
  }

  /**
   * 更新规则
   * @param customerTagRuleEntities
   */
  @Override
  @Transactional
  public void update(Collection<CustomerTagRuleEntity> customerTagRuleEntities) {
    this.updateValidate(customerTagRuleEntities);
    this.customerTagRuleRepository.updateBatchById(customerTagRuleEntities);
  }

  /**
   * 更新数据验证
   * @param customerTagRuleEntities
   */
  private void updateValidate(Collection<CustomerTagRuleEntity> customerTagRuleEntities) {
    Validate.notEmpty(customerTagRuleEntities, "更新规则时，数据不能为空");
    for(CustomerTagRuleEntity rule : customerTagRuleEntities){
      Validate.notBlank(rule.getCustomerTagId(), "更新规则时,标签关联id不能为空");
      Validate.notBlank(rule.getTagAttributes(), "更新规则时,标签属性不能为空");
      Validate.notBlank(rule.getTagSubdivision(), "更新规则时,标签细分不能为空");
      Validate.notBlank(rule.getTagExpression(), "更新规则时,计算符号不能为空");
    }
  }

  /**
   * 创建数据验证
   * @param customerTagRuleEntities
   */
  private void createValidate(Collection<CustomerTagRuleEntity> customerTagRuleEntities) {
    Validate.notEmpty(customerTagRuleEntities, "创建规则时，数据不能为空");
    for(CustomerTagRuleEntity rule : customerTagRuleEntities){
      Validate.notBlank(rule.getCustomerTagId(), "创建规则时,标签关联id不能为空");
      Validate.notBlank(rule.getTagAttributes(), "创建规则时,标签属性不能为空");
      Validate.notBlank(rule.getTagSubdivision(), "创建规则时,标签细分不能为空");
      Validate.notBlank(rule.getTagExpression(), "创建规则时,计算符号不能为空");
    }
  }
}
