/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.local.entity.CustomerAddressEntity;
import com.biz.crm.mdm.business.customer.local.service.CustomerAddressService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerAddressDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba2\u6237\u4fe1\u606f: CustomerAddress: \u5ba2\u6237\u6536\u8d27\u5730\u5740\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/customerAddress/customerAddress"})
public class CustomerAddressController {
    private static final Logger log = LoggerFactory.getLogger(CustomerAddressController.class);
    @Autowired(required=false)
    private CustomerAddressService customerAddressService;

    @ApiOperation(value="\u65b0\u589e\u5ba2\u6237\u6536\u8d27\u5730\u5740")
    @PostMapping(value={"/create"})
    public Result<CustomerAddressEntity> create(@RequestBody CustomerAddressDto dto) {
        try {
            return Result.ok((Object)((Object)this.customerAddressService.create(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u5ba2\u6237\u6536\u8d27\u5730\u5740")
    @PatchMapping(value={"/update"})
    public Result<CustomerAddressEntity> update(@RequestBody CustomerAddressDto dto) {
        try {
            return Result.ok((Object)((Object)this.customerAddressService.update(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.customerAddressService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

