/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerQueryDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerSelectDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/customer/customer"})
@Api(tags={"\u5ba2\u6237\u4fe1\u606f: CustomerVo: \u5ba2\u6237\u7ba1\u7406"})
public class CustomerVoController {
    private static final Logger log = LoggerFactory.getLogger(CustomerVoController.class);
    @Autowired(required=false)
    private CustomerVoService customerVoService;

    @ApiOperation(value="\u901a\u8fc7\u5ba2\u6237ID\u6216\u8005\u5ba2\u6237\u7f16\u7801\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u8be6\u60c5(\u5305\u542b\u5ba2\u6237\u4fe1\u606f\u6240\u6709\u5173\u8054\u6570\u636e)")
    @GetMapping(value={"/findDetailsByIdOrCode"})
    public Result<CustomerVo> findDetailsByIdOrCode(@RequestParam(value="id", required=false) @ApiParam(name="id", value="\u4e3b\u952eID") String id, @RequestParam(value="customerCode", required=false) @ApiParam(name="customerCode", value="\u5ba2\u6237\u7f16\u7801") String customerCode) {
        try {
            return Result.ok((Object)this.customerVoService.findDetailsByIdOrCode(id, customerCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba2\u6237\u4fe1\u606f\u4e0b\u62c9\u6846\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByCustomerSelectDto"})
    public Result<Page<CustomerVo>> findByCustomerSelectDto(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="CustomerSelectDto", value="\u4e0b\u62c9\u5206\u9875Dto") CustomerSelectDto dto) {
        try {
            return Result.ok((Object)this.customerVoService.findByCustomerSelectDto(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u4f01\u4e1a\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u5339\u914d\u7684\u5ba2\u6237\u4fe1\u606f")
    @GetMapping(value={"/findByOrgCodes"})
    public Result<List<CustomerVo>> findByOrgCodes(@RequestParam(value="orgCodeList") List<String> orgCodeList) {
        try {
            return Result.ok((Object)this.customerVoService.findByOrgCodes(orgCodeList));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5224\u65ad\u5ba2\u6237\u662f\u5426\u5728\u7ec4\u7ec7\u5185")
    @GetMapping(value={"/existByCustomer7OrgIn7OrgNotIn"})
    public Result<Boolean> existByCustomer7OrgIn7OrgNotIn(@RequestParam(value="customerCode") String customerCode, @RequestParam(value="orgCodeIn") List<String> orgCodeIn, @RequestParam(value="orgCodeNotIn") List<String> orgCodeNotIn) {
        try {
            Boolean isExist = this.customerVoService.existByCustomer7OrgIn7OrgNotIn(customerCode, orgCodeIn, orgCodeNotIn);
            return Result.ok((Object)isExist);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u5bf9\u5e94\u7684\u5ba2\u6237\u4fe1\u606f")
    @GetMapping(value={"/findByCustomerCodes"})
    public Result<List<CustomerVo>> findByCustomerCodes(@RequestParam(value="customerCodeList") List<String> customerCodeList) {
        try {
            return Result.ok((Object)this.customerVoService.findByCustomerCodes(customerCodeList));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u5bf9\u5e94\u7684\u5ba2\u6237\u4fe1\u606f\u53ca\u8054\u7cfb\u4eba")
    @PostMapping(value={"/findCustomerAndContactByCustomerCodes"})
    public Result<List<CustomerVo>> findCustomerAndContactByCustomerCodes(@RequestBody List<String> customerCodeList) {
        try {
            return Result.ok((Object)this.customerVoService.findCustomerAndContactByCustomerCodes(customerCodeList));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5224\u65ad\u5ba2\u6237\u662f\u5426\u5b58\u5728")
    @GetMapping(value={"/existByCustomerCode"})
    public Result<Boolean> existByCustomerCode(@RequestParam(value="customerCode") String customerCode) {
        try {
            return Result.ok((Object)this.customerVoService.existByCustomerCode(customerCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u5bf9\u5e94\u7684\u5ba2\u6237\u4fe1\u606f-\u5305\u542b\u4e3b\u4fe1\u606f+\u7ec4\u7ec7\u4fe1\u606f")
    @GetMapping(value={"/findForPriceByCustomerCodes"})
    public Result<List<CustomerVo>> findForPriceByCustomerCodes(@RequestParam(value="customerCodeSet") Set<String> customerCodeSet) {
        try {
            return Result.ok((Object)this.customerVoService.findForPriceByCustomerCodes(customerCodeSet));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6e20\u9053\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u5bf9\u5e94\u7684\u5ba2\u6237\u4fe1\u606f")
    @GetMapping(value={"/findByChannels"})
    public Result<List<CustomerVo>> findByChannels(@RequestParam(value="channelList") List<String> channelList) {
        try {
            return Result.ok((Object)this.customerVoService.findByChannels(channelList));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5224\u65ad\u5ba2\u6237\u662f\u5426\u5728\u6e20\u9053\u5185")
    @GetMapping(value={"/existByCustomerCodeAndChannels"})
    public Result<Boolean> existByCustomerCodeAndChannels(@RequestParam(value="channelList") List<String> channelList, @RequestParam(value="customerCode") String customerCode) {
        try {
            return Result.ok((Object)this.customerVoService.existByCustomerCodeAndChannels(channelList, customerCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6e20\u9053\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u5bf9\u5e94\u7684\u5ba2\u6237\u4fe1\u606f")
    @GetMapping(value={"/findByTypes"})
    public Result<List<CustomerVo>> findByTypes(@RequestParam(value="typeList") List<String> typeList) {
        try {
            return Result.ok((Object)this.customerVoService.findByTypes(typeList));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6e20\u9053\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u5bf9\u5e94\u7684\u5ba2\u6237\u4fe1\u606f")
    @GetMapping(value={"/findCustomerCodesByOrgCodesAndChannelsAndTags"})
    public Result<Set<String>> findCustomerCodesByOrgCodesAndChannelsAndTags(@RequestParam(value="orgCodes", required=false) List<String> orgCodes, @RequestParam(value="channels", required=false) List<String> channels, @RequestParam(value="tags", required=false) List<String> tags) {
        try {
            return Result.ok((Object)this.customerVoService.findCustomerCodesByOrgCodesAndChannelsAndTags(orgCodes, channels, tags));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eCustomerQueryDto\u83b7\u53d6\u5bf9\u5e94\u7684\u5ba2\u6237\u7f16\u7801\u96c6\u5408")
    @PostMapping(value={"/findByCustomerQueryDto"})
    public Result<Set<String>> findByCustomerQueryDto(@RequestBody CustomerQueryDto dto) {
        try {
            return Result.ok((Object)this.customerVoService.findByCustomerQueryDto(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u83b7\u53d6\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u6240\u6709\u7684\u5ba1\u6838\u901a\u8fc7\u4e14\u672a\u5220\u9664\u7684\u7ecf\u9500\u5546\u4fe1\u606f")
    @GetMapping(value={"/findAllowSaleCustomerByOrgCodes"})
    public Result<Map<String, Set<String>>> findAllowSaleCustomerByOrgCodes(@RequestParam(value="orgCodes") Set<String> orgCodes) {
        try {
            return Result.ok((Object)this.customerVoService.findAllowSaleCustomerByOrgCodes(orgCodes));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u9ad8\u5fb7id\u96c6\u5408\u83b7\u53d6\u5bf9\u5e94\u7684\u5ba2\u6237\u4fe1\u606f")
    @GetMapping(value={"/findByAmapIds"})
    public Result<List<CustomerVo>> findByAmapIds(@RequestParam(value="amapIds") Set<String> amapIds) {
        try {
            return Result.ok((Object)this.customerVoService.findByAmapIds(amapIds));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

