/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.customer.local.entity.CustomerTagEntity;
import com.biz.crm.mdm.business.customer.local.mapper.CustomerTagMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CustomerTagRepository
extends ServiceImpl<CustomerTagMapper, CustomerTagEntity> {
    public List<CustomerTagEntity> findByCustomerCode(String customerCode) {
        return ((CustomerTagMapper)this.baseMapper).findByCustomerCode(customerCode, TenantUtils.getTenantCode());
    }

    public void deleteBatch(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public CustomerTagEntity findByTagName(String tagName) {
        return (CustomerTagEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CustomerTagEntity::getTagName, (Object)tagName)).one());
    }

    public void updateEnableStatusByIds(List<String> ids, String code) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)code)).update();
    }

    public CustomerTagEntity findDetailById(String id) {
        return ((CustomerTagMapper)this.baseMapper).findDetailById(id);
    }

    public List<CustomerTagEntity> findDetailByStatusAndUpdateType(String status, Boolean type) {
        return ((CustomerTagMapper)this.baseMapper).findDetailByStatus(status, type);
    }
}

