/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.customer.local.entity.CustomerAddressEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerAddressRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerAddressService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerAddressDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerAddressPageDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerAddressService")
public class CustomerAddressServiceImpl
implements CustomerAddressService {
    @Autowired(required=false)
    private CustomerAddressRepository customerAddressRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public CustomerAddressEntity create(CustomerAddressDto dto) {
        this.createValidation(dto);
        CustomerAddressEntity entity = (CustomerAddressEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CustomerAddressEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDefaultAddress(Boolean.TRUE.equals(entity.getDefaultAddress()));
        if (Boolean.TRUE.equals(entity.getDefaultAddress())) {
            this.customerAddressRepository.unbindDefaultAddressByCustomerCode(dto.getCustomerCode(), dto.getTenantCode());
        }
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(DelFlagStatusEnum.NORMAL.getCode());
        this.customerAddressRepository.save((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public CustomerAddressEntity update(CustomerAddressDto dto) {
        this.updateValidation(dto);
        CustomerAddressEntity entity = (CustomerAddressEntity)((Object)this.customerAddressRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u5ba2\u6237\u6536\u8d27\u5730\u5740\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)entity.getCustomerCode().equals(dto.getCustomerCode()), (String)"\u6240\u5c5e\u5ba2\u6237\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        CustomerAddressEntity updateEntity = (CustomerAddressEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CustomerAddressEntity.class, HashSet.class, ArrayList.class, new String[0]));
        updateEntity.setDefaultAddress(Boolean.TRUE.equals(updateEntity.getDefaultAddress()));
        if (Boolean.TRUE.equals(updateEntity.getDefaultAddress())) {
            this.customerAddressRepository.unbindDefaultAddressByCustomerCode(dto.getCustomerCode(), dto.getTenantCode());
        }
        this.customerAddressRepository.updateById((Object)updateEntity);
        return updateEntity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.customerAddressRepository.listByIds(ids);
        Validate.isTrue((CollectionUtils.isNotEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.customerAddressRepository.updateDelFlagByIds(ids);
    }

    @Override
    public Page<CustomerAddressEntity> findByConditions(Pageable pageable, CustomerAddressPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (CustomerAddressPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new CustomerAddressPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.customerAddressRepository.findByConditions(pageable, dto);
    }

    @Override
    public CustomerAddressEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.customerAddressRepository.findById(id);
    }

    private void createValidation(CustomerAddressDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setId(null);
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCityCode(), (String)"\u7f3a\u5931\u5e02\u7ea7\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDistrictCode(), (String)"\u7f3a\u5931\u533a\u7ea7\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProvinceCode(), (String)"\u7f3a\u5931\u7701\u7ea7\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDetailedAddress(), (String)"\u7f3a\u5931\u8be6\u7ec6\u5730\u5740", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getContactName(), (String)"\u7f3a\u5931\u8054\u7cfb\u4eba", (Object[])new Object[0]);
        Validate.isTrue((dto.getDetailedAddress().length() < 128 ? 1 : 0) != 0, (String)"\u8be6\u7ec6\u5730\u5740\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dto.getContactName().length() < 64 ? 1 : 0) != 0, (String)"\u8054\u7cfb\u4eba\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void updateValidation(CustomerAddressDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCityCode(), (String)"\u7f3a\u5931\u5e02\u7ea7\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDistrictCode(), (String)"\u7f3a\u5931\u533a\u7ea7\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProvinceCode(), (String)"\u7f3a\u5931\u7701\u7ea7\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDetailedAddress(), (String)"\u7f3a\u5931\u8be6\u7ec6\u5730\u5740", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getContactName(), (String)"\u7f3a\u5931\u8054\u7cfb\u4eba", (Object[])new Object[0]);
        Validate.isTrue((dto.getDetailedAddress().length() < 128 ? 1 : 0) != 0, (String)"\u8be6\u7ec6\u5730\u5740\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dto.getContactName().length() < 64 ? 1 : 0) != 0, (String)"\u8054\u7cfb\u4eba\uff0c\u5728\u8fdb\u884c\u7f16\u8f91\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

