/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.local.entity.CustomerAddressEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerAddressRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerAddressService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerAddressPageDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerAddressQueryDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerAddressVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerAddressVo;
import com.biz.crm.mdm.business.region.sdk.service.RegionVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class CustomerAddressVoServiceImpl
implements CustomerAddressVoService {
    @Autowired(required=false)
    private CustomerAddressService customerAddressService;
    @Autowired(required=false)
    private RegionVoService regionVoService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerAddressRepository customerAddressRepository;

    public Page<CustomerAddressVo> findByConditions(Pageable pageable, CustomerAddressPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (CustomerAddressPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new CustomerAddressPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<CustomerAddressEntity> entityPage = this.customerAddressService.findByConditions(pageable, dto);
        List entities = entityPage.getRecords();
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        pageResult.setRecords(this.covertEntityToVo(entities));
        return pageResult;
    }

    public CustomerAddressVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        CustomerAddressEntity entity = this.customerAddressService.findById(id);
        if (Objects.isNull((Object)entity)) {
            return null;
        }
        return this.covertEntityToVo(Lists.newArrayList((Object[])new CustomerAddressEntity[]{entity})).get(0);
    }

    public List<CustomerAddressVo> findByCustomerAddressQueryDto(CustomerAddressQueryDto dto) {
        if (Objects.isNull(dto) || StringUtils.isBlank((CharSequence)dto.getCustomerCode())) {
            return Lists.newLinkedList();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<CustomerAddressEntity> entities = this.customerAddressRepository.findByCustomerAddressQueryDto(dto);
        return this.covertEntityToVo(entities);
    }

    private List<CustomerAddressVo> covertEntityToVo(List<CustomerAddressEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, CustomerAddressEntity.class, CustomerAddressVo.class, HashSet.class, ArrayList.class, new String[0]));
        ArrayList regionCodes = Lists.newArrayList();
        list.forEach(vo -> {
            if (StringUtils.isNotBlank((CharSequence)vo.getCityCode())) {
                regionCodes.add(vo.getCityCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getDistrictCode())) {
                regionCodes.add(vo.getDistrictCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getProvinceCode())) {
                regionCodes.add(vo.getProvinceCode());
            }
        });
        if (CollectionUtils.isEmpty((Collection)regionCodes)) {
            return Lists.newArrayList();
        }
        Map regionMap = this.regionVoService.findRegionCodeNameMap((List)regionCodes);
        list.forEach(vo -> {
            vo.setCityName((String)regionMap.get(vo.getCityCode()));
            vo.setDistrictName((String)regionMap.get(vo.getDistrictCode()));
            vo.setProvinceName((String)regionMap.get(vo.getProvinceCode()));
        });
        return list;
    }

    public Page<CustomerAddressVo> findCustomerAddressByCurrentCustomer(Pageable pageable, CustomerAddressPageDto dto) {
        if (dto == null || StringUtils.isBlank((CharSequence)dto.getCustomerCode())) {
            Page pageResult = new Page(0L, 0L, 0L);
            return pageResult;
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.findByConditions(pageable, dto);
    }
}

