/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import com.biz.crm.mdm.business.customer.local.entity.CustomerMediaEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerMediaRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerMediaService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerUploadDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerMediaService")
public class CustomerMediaServiceImpl
implements CustomerMediaService {
    @Autowired(required=false)
    private CustomerMediaRepository customerMediaRepository;

    @Override
    @Transactional
    public void rebindCustomerCode(List<CustomerUploadDto> dtoList, String customerCode) {
        Validate.notBlank((CharSequence)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        this.customerMediaRepository.deleteByCustomerCode(customerCode, tenantCode);
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        List entities = dtoList.stream().filter(dto -> Objects.nonNull(dto) && StringUtils.isNotEmpty((CharSequence)dto.getFileCode()) && Objects.nonNull(dto.getFileType())).map(dto -> {
            CustomerMediaEntity entity = new CustomerMediaEntity();
            entity.setOriginalFileName(dto.getOriginalFileName());
            entity.setCustomerCode(customerCode);
            entity.setFileCode(dto.getFileCode());
            entity.setFileType(dto.getFileType());
            entity.setTenantCode(tenantCode);
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.customerMediaRepository.saveBatch(entities);
    }
}

