/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import com.biz.crm.mdm.business.customer.local.entity.CustomerEntity;
import com.biz.crm.mdm.business.customer.local.entity.CustomerROrgEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerROrgRepository;
import com.biz.crm.mdm.business.customer.local.repository.CustomerRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerROrgService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerRelateOrgEventDto;
import com.biz.crm.mdm.business.customer.sdk.event.CustomerRelateOrgEventListener;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerROrgService")
public class CustomerROrgServiceImpl
implements CustomerROrgService {
    @Autowired(required=false)
    private CustomerROrgRepository customerROrgRepository;
    @Autowired(required=false)
    private CustomerRepository customerRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    private static volatile Cache<String, List<CustomerROrgEntity>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CustomerROrgServiceImpl() {
        if (cache != null) return;
        Class<CustomerROrgServiceImpl> clazz = CustomerROrgServiceImpl.class;
        synchronized (CustomerROrgServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    @Transactional
    public void rebindCustomerCode(String orgCode, String customerCode) {
        Validate.notBlank((CharSequence)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        this.customerROrgRepository.deleteByCustomerCode(customerCode, tenantCode);
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            return;
        }
        List entities = Arrays.stream(orgCode.split(",")).filter(StringUtils::isNotBlank).map(code -> {
            CustomerROrgEntity entity = new CustomerROrgEntity();
            entity.setOrgCode((String)code);
            entity.setCustomerCode(customerCode);
            entity.setTenantCode(tenantCode);
            return entity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        this.customerROrgRepository.saveBatch(entities);
    }

    @Override
    @Transactional
    public void rebindOrgCode(String orgCode, String originOrgCode, List<String> customerCodeList) {
        this.customerROrgRepository.rebindOrgCode(orgCode, originOrgCode, customerCodeList, TenantUtils.getTenantCode());
        List<CustomerEntity> customerEntityList = this.customerRepository.findByCodes(customerCodeList, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(customerEntityList)) {
            return;
        }
        List voList = (List)this.nebulaToolkitService.copyCollectionByBlankList(customerEntityList, CustomerEntity.class, CustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (CustomerVo item : voList) {
            CustomerRelateOrgEventDto eventDto = new CustomerRelateOrgEventDto();
            eventDto.setOldOrgCode(originOrgCode);
            eventDto.setNewOrgCode(orgCode);
            eventDto.setCustomerVo(item);
            SerializableBiConsumer & Serializable onRebind = CustomerRelateOrgEventListener::onRebind;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, CustomerRelateOrgEventListener.class, (SerializableBiConsumer)onRebind);
        }
    }

    @Override
    public List<CustomerROrgEntity> findByCustomerCodes(Set<String> customerCodes) {
        if (CollectionUtils.isEmpty(customerCodes)) {
            return Lists.newLinkedList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), customerCodes});
        List<CustomerROrgEntity> graph = (List<CustomerROrgEntity>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.customerROrgRepository.findByCustomerCodes(Lists.newArrayList(customerCodes), TenantUtils.getTenantCode());
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    public List<CustomerROrgEntity> findAllowSaleCustomerByOrgCodes(Set<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return Lists.newLinkedList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), orgCodes});
        List<CustomerROrgEntity> graph = (List<CustomerROrgEntity>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.customerROrgRepository.findAllowSaleCustomerByOrgCodes(orgCodes);
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }
}

