/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.local.repository.CustomerTagVoRepository;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerTagDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerTagVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerTagVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerTagVoServiceImpl
implements CustomerTagVoService {
    @Autowired(required=false)
    private CustomerTagVoRepository customerTagVoRepository;
    private static volatile Cache<String, List<CustomerTagVo>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CustomerTagVoServiceImpl() {
        if (cache != null) return;
        Class<CustomerTagVoServiceImpl> clazz = CustomerTagVoServiceImpl.class;
        synchronized (CustomerTagVoServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Page<CustomerTagVo> findByConditions(Pageable pageable, CustomerTagDto customerTagDto) {
        customerTagDto = (CustomerTagDto)ObjectUtils.defaultIfNull((Object)customerTagDto, (Object)new CustomerTagDto());
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        customerTagDto.setTenantCode(TenantUtils.getTenantCode());
        return this.customerTagVoRepository.findByConditions(pageable, customerTagDto);
    }

    public List<CustomerTagVo> findByCustomerCodes(List<String> customerCodes) {
        if (CollectionUtils.isEmpty(customerCodes)) {
            return Lists.newLinkedList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), customerCodes});
        List<CustomerTagVo> graph = (List<CustomerTagVo>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.customerTagVoRepository.findByCustomerCodes(customerCodes);
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }
}

