/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.local.entity.CustomerDockingEntity;
import com.biz.crm.mdm.business.customer.local.entity.CustomerEntity;
import com.biz.crm.mdm.business.customer.local.entity.CustomerROrgEntity;
import com.biz.crm.mdm.business.customer.local.repository.CustomerDockingRepository;
import com.biz.crm.mdm.business.customer.local.repository.CustomerRepository;
import com.biz.crm.mdm.business.customer.local.service.CustomerContactService;
import com.biz.crm.mdm.business.customer.local.service.CustomerROrgService;
import com.biz.crm.mdm.business.customer.local.service.CustomerService;
import com.biz.crm.mdm.business.customer.org.sdk.service.CustomerOrgVoSdkService;
import com.biz.crm.mdm.business.customer.org.sdk.vo.CustomerOrgVo;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerQueryDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerSelectDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerContactVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerDockingVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerRelateOrgVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerSaleAreaVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.dto.RelateOrgCodeQueryDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.AbstractRelationView;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.region.sdk.service.RegionVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerVoServiceImpl
implements CustomerVoService {
    @Autowired(required=false)
    private CustomerService customerService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private CustomerOrgVoSdkService customerOrgVoSdkService;
    @Autowired(required=false)
    private UserInfoVoService userInfoVoService;
    @Autowired(required=false)
    private PositionVoService positionVoService;
    @Autowired(required=false)
    private CustomerRepository customerRepository;
    @Autowired(required=false)
    private CustomerROrgService customerROrgService;
    @Autowired(required=false)
    private CustomerDockingRepository customerDockingRepository;
    @Autowired(required=false)
    private CustomerContactService customerContactService;
    @Autowired(required=false)
    private RegionVoService regionVoService;

    public CustomerVo findDetailsByIdOrCode(String id, String customerCode) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{id, customerCode})) {
            return null;
        }
        CustomerEntity entity = this.customerService.findDetailsByIdOrCode(id, customerCode);
        if (Objects.isNull((Object)entity)) {
            return null;
        }
        CustomerVo customerVo = this.covertEntityToVo(entity);
        this.perfectDockingInfo(customerVo.getDockingList());
        this.perfectSaleAreaInfo(customerVo.getSaleAreaList());
        return customerVo;
    }

    private void perfectSaleAreaInfo(List<CustomerSaleAreaVo> saleAreaList) {
        if (CollectionUtils.isEmpty(saleAreaList)) {
            return;
        }
        ArrayList orgCodeList = Lists.newArrayList();
        saleAreaList.forEach(customerSaleAreaVo -> {
            if (StringUtils.isNotBlank((CharSequence)customerSaleAreaVo.getAreaOne())) {
                orgCodeList.add(customerSaleAreaVo.getAreaOne());
            }
            if (StringUtils.isNotBlank((CharSequence)customerSaleAreaVo.getAreaTwo())) {
                orgCodeList.add(customerSaleAreaVo.getAreaTwo());
            }
            if (StringUtils.isNotBlank((CharSequence)customerSaleAreaVo.getAreaThree())) {
                orgCodeList.add(customerSaleAreaVo.getAreaThree());
            }
        });
        if (CollectionUtils.isEmpty((Collection)orgCodeList)) {
            return;
        }
        List orgList = this.orgVoService.findByOrgCodes((List)orgCodeList);
        if (CollectionUtils.isEmpty((Collection)orgList)) {
            return;
        }
        Map<String, String> orgNameMap = orgList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName, (key1, key2) -> key2));
        for (CustomerSaleAreaVo customerSaleAreaVo2 : saleAreaList) {
            customerSaleAreaVo2.setAreaOneName(orgNameMap.get(customerSaleAreaVo2.getAreaOne()));
            customerSaleAreaVo2.setAreaTwoName(orgNameMap.get(customerSaleAreaVo2.getAreaTwo()));
            customerSaleAreaVo2.setAreaThreeName(orgNameMap.get(customerSaleAreaVo2.getAreaThree()));
        }
    }

    private void perfectDockingInfo(List<CustomerDockingVo> dockingList) {
        List positionList;
        if (CollectionUtils.isEmpty(dockingList)) {
            return;
        }
        Set positionCodes = dockingList.stream().map(CustomerDockingVo::getPositionCode).collect(Collectors.toSet());
        Map<Object, Object> userMap = Maps.newHashMap();
        Map<Object, Object> positionMap = Maps.newHashMap();
        List userList = this.userInfoVoService.findByPositionCodes(positionCodes);
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            userMap = userList.stream().collect(Collectors.toMap(UserInfoVo::getPositionCode, t -> t, (key1, key2) -> key2));
        }
        if (!CollectionUtils.isEmpty((Collection)(positionList = this.positionVoService.findDetailsByIdsOrCodes(null, (List)Lists.newArrayList(positionCodes))))) {
            positionMap = positionList.stream().collect(Collectors.toMap(PositionVo::getPositionCode, t -> t, (key1, key2) -> key2));
        }
        this.perfectDockingPositionUserInfo(dockingList, userMap, positionMap);
        this.perfectDockingOrgInfo(dockingList, positionMap);
    }

    private void perfectDockingPositionUserInfo(List<CustomerDockingVo> dockingList, Map<String, UserInfoVo> userMap, Map<String, PositionVo> positionMap) {
        for (CustomerDockingVo customerDockingVo : dockingList) {
            UserInfoVo userInfoVo = userMap.get(customerDockingVo.getPositionCode());
            PositionVo positionVo = positionMap.get(customerDockingVo.getPositionCode());
            if (Objects.nonNull(userInfoVo)) {
                customerDockingVo.setFullName(userInfoVo.getFullName());
                customerDockingVo.setContact(userInfoVo.getUserPhone());
                customerDockingVo.setUserName(userInfoVo.getUserName());
            }
            if (!Objects.nonNull(positionVo)) continue;
            customerDockingVo.setPositionName(positionVo.getPositionName());
        }
    }

    private void perfectDockingOrgInfo(List<CustomerDockingVo> dockingList, Map<String, PositionVo> positionMap) {
        HashSet orgCodeSet = Sets.newHashSet();
        dockingList.forEach(customerDockingVo -> {
            PositionVo positionVo = (PositionVo)positionMap.get(customerDockingVo.getPositionCode());
            if (Objects.isNull(positionVo) || CollectionUtils.isEmpty((Collection)positionVo.getRelationData())) {
                return;
            }
            positionVo.getRelationData().stream().filter(prv -> "org".equals(prv.getRelationKey()) && !CollectionUtils.isEmpty((Collection)prv.getRelationData())).collect(Collectors.toList()).forEach(positionRelationVo -> {
                List orgCodes = positionRelationVo.getRelationData().stream().map(AbstractRelationView::getCode).collect(Collectors.toList());
                customerDockingVo.setOrgCode(String.join((CharSequence)",", orgCodes));
                orgCodeSet.addAll(orgCodes);
            });
        });
        if (CollectionUtils.isEmpty((Collection)orgCodeSet)) {
            return;
        }
        List orgVoList = this.orgVoService.findByOrgCodes((List)Lists.newArrayList((Iterable)orgCodeSet));
        if (CollectionUtils.isEmpty((Collection)orgVoList)) {
            return;
        }
        Map<String, OrgVo> orgMap = orgVoList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, t -> t, (key1, key2) -> key2));
        dockingList.forEach(customerDockingVo -> {
            String orgCode = customerDockingVo.getOrgCode();
            if (StringUtils.isBlank((CharSequence)orgCode)) {
                return;
            }
            List orgNames = Arrays.stream(orgCode.split(",")).map(s -> {
                OrgVo orgVo = (OrgVo)orgMap.get(s);
                return Objects.isNull(orgVo) ? null : orgVo.getOrgName();
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(orgNames)) {
                customerDockingVo.setOrgName(String.join((CharSequence)",", orgNames));
            }
        });
    }

    public Page<CustomerVo> findByCustomerSelectDto(Pageable pageable, CustomerSelectDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (CustomerSelectDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new CustomerSelectDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<CustomerEntity> entityPage = this.customerService.findByCustomerSelectDto(pageable, dto);
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        pageResult.setRecords(this.covertEntityToVo(entityPage.getRecords()));
        return pageResult;
    }

    public List<CustomerVo> findByOrgCodes(List<String> orgCodeList) {
        if (CollectionUtils.isEmpty(orgCodeList)) {
            return Lists.newLinkedList();
        }
        List<CustomerEntity> list = this.customerService.findByOrgCodes(orgCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, CustomerEntity.class, CustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<CustomerVo> findByCustomerCodes(List<String> customerCodeList) {
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return Lists.newLinkedList();
        }
        List<CustomerEntity> list = this.customerService.findByCustomerCodes(customerCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        List customerVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, CustomerEntity.class, CustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<String> customerCodes = customerVos.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCustomerCode())).map(CustomerVo::getCustomerCode).collect(Collectors.toList());
        this.buildOrgInfo(customerCodes, customerVos);
        this.buildCustomerOrgInfo(customerVos);
        this.buildDockingInfo(customerCodes, customerVos);
        this.buildContactInfo(customerCodes, customerVos);
        return customerVos;
    }

    public List<CustomerVo> findCustomerAndContactByCustomerCodes(List<String> customerCodeList) {
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return Lists.newLinkedList();
        }
        List<CustomerEntity> customerEntities = this.customerService.findByCustomerCodes(customerCodeList);
        if (CollectionUtils.isEmpty(customerEntities)) {
            return Lists.newLinkedList();
        }
        List customerVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(customerEntities, CustomerEntity.class, CustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<String> customerCodes = customerVos.stream().map(CustomerVo::getCustomerCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        this.buildContactInfo(customerCodes, customerVos);
        return customerVos;
    }

    private void buildCustomerOrgInfo(List<CustomerVo> customerVos) {
        if (CollectionUtils.isEmpty(customerVos)) {
            return;
        }
        Set customerOrgCodeSet = customerVos.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCustomerOrgCode())).map(CustomerVo::getCustomerOrgCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(customerOrgCodeSet)) {
            return;
        }
        List orgVoList = this.customerOrgVoSdkService.findListByCodes((List)Lists.newArrayList(customerOrgCodeSet));
        if (CollectionUtils.isEmpty((Collection)orgVoList)) {
            return;
        }
        Map<String, String> map = orgVoList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getCustomerOrgCode(), a.getCustomerOrgName()})).collect(Collectors.toMap(CustomerOrgVo::getCustomerOrgCode, CustomerOrgVo::getCustomerOrgName, (a, b) -> a));
        for (CustomerVo item : customerVos) {
            if (StringUtils.isBlank((CharSequence)item.getCustomerOrgCode())) continue;
            item.setCustomerOrgName(map.get(item.getCustomerOrgCode()));
        }
    }

    private void buildContactInfo(List<String> customerCodes, List<CustomerVo> customerVos) {
        List<CustomerContactVo> contactVos = this.customerContactService.findByCustomerCodes(customerCodes);
        if (CollectionUtils.isEmpty(contactVos)) {
            return;
        }
        Map<String, List<CustomerContactVo>> customerContactVoMap = contactVos.stream().collect(Collectors.groupingBy(CustomerContactVo::getCustomerCode));
        customerVos.forEach(customerVo -> customerVo.setContactList((List)customerContactVoMap.get(customerVo.getCustomerCode())));
    }

    private void buildDockingInfo(List<String> customerCodes, List<CustomerVo> customerVos) {
        List<CustomerDockingEntity> dockingEntities = this.customerDockingRepository.findByCustomerCodes(customerCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(dockingEntities)) {
            return;
        }
        HashMap dockingMap = Maps.newHashMap();
        dockingEntities.forEach(customerDockingEntity -> {
            List list = dockingMap.getOrDefault(customerDockingEntity.getCustomerCode(), Lists.newArrayList());
            list.add(customerDockingEntity);
            dockingMap.put(customerDockingEntity.getCustomerCode(), list);
        });
        ArrayList allDockingList = Lists.newArrayList();
        customerVos.forEach(customerVo -> {
            List entities = (List)dockingMap.get(customerVo.getCustomerCode());
            if (CollectionUtils.isEmpty((Collection)entities)) {
                return;
            }
            customerVo.setDockingList((List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)entities, CustomerDockingEntity.class, CustomerDockingVo.class, HashSet.class, ArrayList.class, new String[0]));
            allDockingList.addAll(customerVo.getDockingList());
        });
        this.perfectDockingInfo(allDockingList);
    }

    private void buildOrgInfo(List<String> customerCodes, List<CustomerVo> customerVos) {
        List<Object> customerROrgEntityList = Lists.newLinkedList();
        if (!CollectionUtils.isEmpty(customerCodes)) {
            customerROrgEntityList = this.customerROrgService.findByCustomerCodes(new HashSet<String>(customerCodes));
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)customerROrgEntityList) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u7801%s\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u4fe1\u606f\uff01", (Object[])new Object[]{customerCodes});
        }
        Map map = customerROrgEntityList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getCustomerCode(), a.getOrgCode()})).collect(Collectors.groupingBy(CustomerROrgEntity::getCustomerCode, Collectors.mapping(CustomerROrgEntity::getOrgCode, Collectors.toList())));
        Set orgCodeSet = customerROrgEntityList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(CustomerROrgEntity::getOrgCode).collect(Collectors.toSet());
        List orgVoList = this.orgVoService.findByOrgCodes((List)Lists.newArrayList(orgCodeSet));
        Map<String, String> orgMap = orgVoList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getOrgCode(), a.getOrgName()})).collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName, (a, b) -> a));
        for (CustomerVo item : customerVos) {
            List curOrgCodeList = map.get(item.getCustomerCode());
            if (CollectionUtils.isEmpty(curOrgCodeList)) continue;
            LinkedList curOrgList = Lists.newLinkedList();
            for (String orgCode : curOrgCodeList) {
                if (!orgMap.containsKey(orgCode)) continue;
                CustomerRelateOrgVo cur = new CustomerRelateOrgVo();
                cur.setCustomerCode(item.getCustomerCode());
                cur.setOrgCode(orgCode);
                cur.setOrgName(orgMap.get(orgCode));
                curOrgList.add(cur);
            }
            item.setOrgList((List)curOrgList);
        }
    }

    public List<CustomerVo> findByChannels(List<String> channelList) {
        if (CollectionUtils.isEmpty(channelList)) {
            return Lists.newLinkedList();
        }
        List<CustomerEntity> list = this.customerRepository.findByChannels(channelList, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, CustomerEntity.class, CustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<CustomerVo> findByTypes(List<String> typeList) {
        if (CollectionUtils.isEmpty(typeList)) {
            return Lists.newLinkedList();
        }
        List<CustomerEntity> list = this.customerRepository.findByTypes(typeList, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, CustomerEntity.class, CustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Set<String> findCustomerCodesByOrgCodesAndChannelsAndTags(List<String> orgCodes, List<String> channels, List<String> tags) {
        return this.customerRepository.findCustomerCodesByOrgCodesAndChannelsAndTags(orgCodes, channels, tags);
    }

    public List<CustomerVo> findForPriceByCustomerCodes(Set<String> customerCodeSet) {
        if (CollectionUtils.isEmpty(customerCodeSet)) {
            return Lists.newLinkedList();
        }
        List<CustomerEntity> list = this.customerService.findByCustomerCodes(Lists.newArrayList(customerCodeSet));
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        List customerVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, CustomerEntity.class, CustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<String> customerCodes = customerVos.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCustomerCode())).map(CustomerVo::getCustomerCode).collect(Collectors.toList());
        this.buildOrgInfo(customerCodes, customerVos);
        return customerVos;
    }

    public List<CustomerVo> findByAmapIds(Set<String> amapIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(amapIds)) {
            return Lists.newArrayList();
        }
        List<CustomerEntity> list = this.customerRepository.findByAmapIds(amapIds);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, CustomerEntity.class, CustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Set<String> findByCustomerQueryDto(CustomerQueryDto dto) {
        if (Objects.isNull(dto) || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{dto.getCustomerCode(), dto.getCustomerName(), dto.getChannel(), dto.getOrgName(), dto.getDelFlag(), dto.getProcessStatus()})) {
            return Sets.newHashSet();
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOrgName())) {
            OrgQueryDto queryDto = new OrgQueryDto();
            queryDto.setOrgName(dto.getOrgName());
            Set orgCodeSet = this.orgVoService.findByOrgQueryDto(queryDto);
            if (CollectionUtils.isEmpty((Collection)orgCodeSet)) {
                return Sets.newHashSet();
            }
            dto.setOrgCodeSet(orgCodeSet);
        }
        return this.customerRepository.findByCustomerQueryDto(dto);
    }

    public Map<String, Set<String>> findAllowSaleCustomerByOrgCodes(Set<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return Maps.newHashMap();
        }
        RelateOrgCodeQueryDto queryDto = new RelateOrgCodeQueryDto();
        queryDto.setOrgCodeSet(orgCodes);
        queryDto.setSearchType(Integer.valueOf(-1));
        Map orgRuleMap = this.orgVoService.findByRelateOrgCodeQueryDto(queryDto);
        if (CollectionUtils.isEmpty((Map)orgRuleMap)) {
            return Maps.newHashMap();
        }
        List<CustomerROrgEntity> list = this.customerROrgService.findAllowSaleCustomerByOrgCodes(orgRuleMap.keySet());
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map map = list.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getCustomerCode(), a.getOrgCode()}) && orgRuleMap.keySet().contains(a.getOrgCode())).collect(Collectors.groupingBy(CustomerROrgEntity::getCustomerCode, Collectors.mapping(CustomerROrgEntity::getOrgCode, Collectors.toSet())));
        HashMap re = Maps.newHashMap();
        for (Map.Entry item : map.entrySet()) {
            HashSet rule = Sets.newHashSet();
            for (String orgCode : item.getValue()) {
                String s = (String)orgRuleMap.get(orgCode);
                if (StringUtils.isBlank((CharSequence)s)) continue;
                rule.add(s);
            }
            if (CollectionUtils.isEmpty((Collection)rule)) continue;
            re.put(item.getKey(), rule);
        }
        return re;
    }

    public List<CustomerVo> findCountByCreateAccountAndFromTypeAndCreateTimeScope(String createAccount, String fromType, String startDate, String endDate) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{createAccount, fromType, startDate, endDate})) {
            return new ArrayList<CustomerVo>(0);
        }
        List<CustomerEntity> customerEntities = this.customerRepository.findCountByCreateAccountAndFromTypeAndCreateTimeScope(createAccount, fromType, startDate, endDate);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(customerEntities, CustomerEntity.class, CustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Boolean existByCustomerCodeAndChannels(List<String> channelList, String customerCode) {
        CustomerEntity entity = this.customerRepository.findByCustomerCodeAndChannels(customerCode, channelList);
        return ObjectUtils.isNotEmpty((Object)((Object)entity));
    }

    public Boolean existByCustomerCode(String customerCode) {
        CustomerEntity entity = this.customerRepository.findByCustomerCode(customerCode);
        return ObjectUtils.isNotEmpty((Object)((Object)entity));
    }

    public Boolean existByCustomer7OrgIn7OrgNotIn(String customerCode, List<String> orgCodeIn, List<String> orgCodeNotIn) {
        if (CollectionUtils.isEmpty(orgCodeIn)) {
            return false;
        }
        List<CustomerEntity> entities = this.customerRepository.findByCustomer7OrgIn7OrgNotIn(customerCode, orgCodeIn, orgCodeNotIn);
        return !CollectionUtils.isEmpty(entities);
    }

    private CustomerVo covertEntityToVo(CustomerEntity entity) {
        List<CustomerVo> list = this.covertEntityToVo(Lists.newArrayList((Object[])new CustomerEntity[]{entity}));
        return list.get(0);
    }

    private List<CustomerVo> covertEntityToVo(List<CustomerEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByBlankList(entities, CustomerEntity.class, CustomerVo.class, HashSet.class, ArrayList.class, new String[0]));
        LinkedList codes = Lists.newLinkedList();
        for (CustomerVo customerVo : list) {
            codes.add(customerVo.getCityCode());
            codes.add(customerVo.getDistrictCode());
            codes.add(customerVo.getProvinceCode());
        }
        Map regionCodeNameMap = this.regionVoService.findRegionCodeNameMap((List)codes);
        Map<String, List<OrgVo>> orgMap = this.buildOrgMap(entities);
        Map<String, CustomerOrgVo> customerOrgMap = this.buildCustomerOrgMap(entities);
        for (CustomerVo customerVo : list) {
            CustomerOrgVo customerOrgVo;
            List<OrgVo> orgList = orgMap.get(customerVo.getCustomerCode());
            if (!CollectionUtils.isEmpty(orgList)) {
                ArrayList orgNameList = Lists.newArrayList();
                ArrayList orgCodeList = Lists.newArrayList();
                orgList.forEach(a -> {
                    orgNameList.add(a.getOrgName());
                    orgCodeList.add(a.getOrgCode());
                });
                customerVo.setOrgName(String.join((CharSequence)",", orgNameList));
                customerVo.setOrgCode(String.join((CharSequence)",", orgCodeList));
            }
            if (Objects.nonNull(customerOrgVo = customerOrgMap.get(customerVo.getCustomerOrgCode()))) {
                customerVo.setCustomerOrgName(customerOrgVo.getCustomerOrgName());
            }
            customerVo.setUnionName(String.format("%s/%s", ObjectUtils.defaultIfNull((Object)customerVo.getCustomerCode(), (Object)""), ObjectUtils.defaultIfNull((Object)customerVo.getCustomerName(), (Object)"")));
            customerVo.setCityName((String)regionCodeNameMap.get(customerVo.getCityCode()));
            customerVo.setDistrictName((String)regionCodeNameMap.get(customerVo.getDistrictCode()));
            customerVo.setProvinceName((String)regionCodeNameMap.get(customerVo.getProvinceCode()));
        }
        return list;
    }

    private Map<String, List<OrgVo>> buildOrgMap(List<CustomerEntity> entities) {
        HashMap resultMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(entities)) {
            return resultMap;
        }
        HashSet orgCodeList = Sets.newHashSet();
        entities.forEach(customerEntity -> {
            if (!CollectionUtils.isEmpty(customerEntity.getOrgList())) {
                orgCodeList.addAll(customerEntity.getOrgList().stream().map(CustomerROrgEntity::getOrgCode).collect(Collectors.toList()));
            }
        });
        if (CollectionUtils.isEmpty((Collection)orgCodeList)) {
            return resultMap;
        }
        List orgVoList = this.orgVoService.findByOrgCodes((List)Lists.newArrayList((Iterable)orgCodeList));
        if (CollectionUtils.isEmpty((Collection)orgVoList)) {
            return resultMap;
        }
        Map<String, OrgVo> orgMap = orgVoList.stream().collect(Collectors.toMap(OrgVo::getOrgCode, t -> t, (key1, key2) -> key2));
        entities.forEach(customerEntity -> {
            if (CollectionUtils.isEmpty(customerEntity.getOrgList())) {
                return;
            }
            List list = (List)resultMap.get(customerEntity.getCustomerCode());
            if (CollectionUtils.isEmpty((Collection)list)) {
                list = Lists.newArrayList();
                resultMap.put(customerEntity.getCustomerCode(), list);
            }
            for (CustomerROrgEntity customerROrgEntity : customerEntity.getOrgList()) {
                OrgVo orgVo = (OrgVo)orgMap.get(customerROrgEntity.getOrgCode());
                if (!Objects.nonNull(orgVo)) continue;
                list.add(orgVo);
            }
        });
        return resultMap;
    }

    private Map<String, CustomerOrgVo> buildCustomerOrgMap(List<CustomerEntity> entities) {
        HashMap resultMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(entities)) {
            return resultMap;
        }
        List orgCodeList = entities.stream().map(CustomerEntity::getCustomerOrgCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orgCodeList = orgCodeList.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList()))) {
            return resultMap;
        }
        List orgVoList = this.customerOrgVoSdkService.findListByCodes(orgCodeList);
        if (CollectionUtils.isEmpty((Collection)orgVoList)) {
            return resultMap;
        }
        Map<String, CustomerOrgVo> orgMap = orgVoList.stream().collect(Collectors.toMap(CustomerOrgVo::getCustomerOrgCode, t -> t, (key1, key2) -> key2));
        entities.forEach(customerEntity -> {
            CustomerOrgVo customerOrgVo = (CustomerOrgVo)orgMap.get(customerEntity.getCustomerOrgCode());
            if (Objects.nonNull(customerOrgVo)) {
                resultMap.put(customerEntity.getCustomerOrgCode(), customerOrgVo);
            }
        });
        return resultMap;
    }
}

