/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.local.service.notifier;

import com.biz.crm.mdm.business.customer.local.entity.CustomerEntity;
import com.biz.crm.mdm.business.customer.local.model.MultipleConditionModel;
import com.biz.crm.mdm.business.customer.local.service.CustomerService;
import com.biz.crm.mdm.business.position.sdk.event.PositionEventListener;
import com.biz.crm.mdm.business.position.sdk.vo.PositionEventVo;
import com.biz.crm.mdm.business.position.sdk.vo.PositionRelationVo;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CusPositionEventListener
implements PositionEventListener {
    @Autowired(required=false)
    private CustomerService customerService;

    public void onCreate(PositionEventVo vo) {
    }

    public void onUpdate(PositionEventVo oldVo, PositionEventVo newVo) {
    }

    public void onDisable(List<PositionEventVo> voList) {
    }

    public void onEnable(List<PositionEventVo> voList) {
    }

    public void onDelete(List<PositionEventVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        List<String> positionCodes = voList.stream().map(PositionEventVo::getPositionCode).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(positionCodes)) {
            return;
        }
        MultipleConditionModel model = new MultipleConditionModel();
        model.setDockingPositionCodes(positionCodes);
        List<CustomerEntity> list = this.customerService.findByMultipleConditionModel(model);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(list), (String)"\u5b58\u5728\u4e0e\u5ba2\u6237\u5bf9\u63a5\u4eba\u7684\u7ed1\u5b9a\u5173\u7cfb\u4e0d\u80fd\u5220\u9664", (Object[])new Object[0]);
    }

    public List<PositionRelationVo> onRequestByPositionCodes(List<String> positionCodes) {
        return Lists.newArrayList();
    }
}

