package com.biz.crm.mdm.business.customer.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerAddressPageDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerAddressQueryDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerAddressVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerAddressVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 客户信息: CustomerAddressVo: 客户收货地址管理
 *
 * @author ning.zhang
 * @date 2021-10-28 17:48:59
 */
@Slf4j
@Api(tags = "客户信息: CustomerAddressVo: 客户收货地址管理")
@RestController
@RequestMapping(value = {"/v1/customerAddress/customerAddress"})
public class CustomerAddressVoController {

  @Autowired(required = false)
  private CustomerAddressVoService customerAddressVoService;


  @ApiOperation(value = "客户收货地址分页查询")
  @GetMapping("/findByConditions")
  public Result<?> findByConditions(@PageableDefault(50) Pageable pageable,
                                 @ApiParam(name = "CustomerAddressPageDto", value = "分页Dto") CustomerAddressPageDto dto) {
    try {
      return Result.ok(customerAddressVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "通过ID获取客户收货地址详细信息")
  @GetMapping("/findDetailsById")
  public Result<?> findDetailsById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(customerAddressVoService.findDetailsById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 查询客户收货地址列表
   *
   * @param dto dto
   * @return {@link Result}<{@link List}<{@link CustomerAddressVo}>>
   */
  @ApiOperation(value = "查询客户收货地址列表")
  @GetMapping("/findByCustomerAddressQueryDto")
  public Result<List<CustomerAddressVo>> findByCustomerAddressQueryDto(CustomerAddressQueryDto dto) {
    try {
      return Result.ok(customerAddressVoService.findByCustomerAddressQueryDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 商城-客户收货地址分页查询
   * @param pageable
   * @param dto
   * @return {@link Result< Page< CustomerAddressVo>>}
   */
  @ApiOperation(value = "商城-客户收货地址分页查询")
  @GetMapping("/findCustomerAddressByCurrentCustomer")
  public Result<Page<CustomerAddressVo>> findCustomerAddressByCurrentCustomer(@PageableDefault(50) Pageable pageable,
                                                                              @ApiParam(name = "CustomerAddressPageDto", value = "分页Dto") CustomerAddressPageDto dto) {
    try {
      return Result.ok(customerAddressVoService.findCustomerAddressByCurrentCustomer(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
