package com.biz.crm.mdm.business.customer.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerClientDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerClientVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerClientVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 经销商客户vo http相关接口
 *
 * @author songjingen
 */
@Slf4j
@RestController
@RequestMapping("/v1/customer/customerClientVo")
@Api(tags = "客户信息: CustomerClientVo: 经销商客户vo")
public class CustomerClientVoController {

  @Autowired(required = false)
  private CustomerClientVoService customerClientVoService;

  /**
   * 查询当前用户及其下属所关联的客户信息分页列表
   * <p>
   * 用户账号和租户必传
   *
   * @param dto      查询对象
   * @param pageable 分页信息
   * @return Page<CustomerClientVo> 查询当前用户及其下属所关联的客户信息分页列表
   */
  @ApiOperation(value = "查询当前用户及其下属所关联的客户信息分页列表")
  @GetMapping("/findChildrenPageByCustomerClientDto")
  public Result<Page<CustomerClientVo>> findChildrenPageByCustomerClientDto(@PageableDefault(50) Pageable pageable,
                                                                            @ApiParam(name = "CustomerClientDto", value = "分页Dto") CustomerClientDto dto) {
    try {
      return Result.ok(customerClientVoService.findChildrenPageByCustomerClientDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
