package com.biz.crm.mdm.business.customer.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerTagDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerTagVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerTagVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 客户信息: customerTag: 客户标签管理
 *
 * @author ning.zhang
 * @date 2021-10-28 17:48:59
 */
@Slf4j
@Api(tags = "客户信息: customerTag: 客户标签管理")
@RestController
@RequestMapping(value = {"/v1/customerTag/customerTag"})
public class CustomerTagVoController {

  @Autowired(required = false)
  private CustomerTagVoService customerTagVoService;


  /**
   * 多条件分页查询
   * @return
   */
  @ApiOperation(value = "多条件分页查询(可适用于列表分页查询和公用分页弹框)", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findByConditions")
  public Result<Page<CustomerTagVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                      @ApiParam(name = "customerTagDto", value = "分页Dto") CustomerTagDto customerTagDto) {
    try {
      Page<CustomerTagVo> result = this.customerTagVoService.findByConditions(pageable, customerTagDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据客户编码集合获取对应的客户标签信息
   *
   * @param customerCodeList 客户编码集合
   * @return 客户标签信息集合
   */
  @ApiOperation(value = "根据客户编码集合获取对应的客户标签信息")
  @GetMapping("/findByCustomerCodes")
  public Result<List<CustomerTagVo>> findByCustomerCodes(
      @RequestParam("customerCodeList") List<String> customerCodeList) {
    try {
      return Result.ok(this.customerTagVoService.findByCustomerCodes(customerCodeList));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
