package com.biz.crm.mdm.business.customer.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 客户收货地址实体类
 *
 * @author ning.zhang
 * @date 2021/10/28
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerAddressEntity", description = "客户收货地址实体类")
@Entity
@TableName("mdm_customer_address")
@Table(name = "mdm_customer_address", indexes = {
    @Index(name = "mdm_customer_address_index1", columnList = "customer_code"),
    @Index(name = "mdm_customer_address_index2", columnList = "tenant_code")
})
@org.hibernate.annotations.Table(appliesTo = "mdm_customer_address", comment = "客户收货地址表")
public class CustomerAddressEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = 8572125054461710670L;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  @Column(name = "city_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '市编码'")
  private String cityCode;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  @Column(name = "district_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '区编码'")
  private String districtCode;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  @Column(name = "province_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '省编码'")
  private String provinceCode;

  /**
   * 送达方编码
   */
  @ApiModelProperty("送达方编码")
  @Column(name = "destination_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '送达方编码'")
  private String destinationCode;

  /**
   * 送达方名称
   */
  @ApiModelProperty("送达方名称")
  @Column(name = "destination_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '送达方名称'")
  private String destinationName;

  /**
   * 详细地址
   */
  @ApiModelProperty("详细地址")
  @Column(name = "detailed_address", length = 128, columnDefinition = "VARCHAR(128) COMMENT '详细地址'")
  private String detailedAddress;

  /**
   * 联系人
   */
  @ApiModelProperty("联系人")
  @Column(name = "contact_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '联系人'")
  private String contactName;

  /**
   * 联系电话
   */
  @ApiModelProperty("联系电话")
  @Column(name = "contact_phone", length = 64, columnDefinition = "VARCHAR(64) COMMENT '联系电话'")
  private String contactPhone;

  /**
   * 是否默认地址，1：是，0：否
   */
  @ApiModelProperty("是否默认地址，1：是，0：否")
  @Column(name = "default_address", columnDefinition = "int(1) COMMENT '是否默认地址，1：是，0：否'")
  private Boolean defaultAddress;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码'")
  private String customerCode;

  /**
   * 有效开始时间
   */
  @ApiModelProperty("有效开始时间")
  @Column(name = "start_time", length = 64, columnDefinition = "VARCHAR(64) COMMENT '有效开始时间'")
  private String startTime;

  /**
   * 有效结束时间
   */
  @ApiModelProperty("有效结束时间")
  @Column(name = "end_time", length = 64, columnDefinition = "VARCHAR(64) COMMENT '有效结束时间'")
  private String endTime;

}
