package com.biz.crm.mdm.business.customer.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 客户信息销售区域实体
 *
 * @author ning.zhang
 * @date 2021/10/26
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerSaleAreaEntity", description = "客户销售区域实体")
@Entity
@TableName("mdm_customer_sale_area")
@Table(name = "mdm_customer_sale_area", indexes = {
    @Index(name = "customer_sale_area_index1", columnList = "customer_code"),
    @Index(name = "customer_sale_area_index2", columnList = "tenant_code")
})
@org.hibernate.annotations.Table(appliesTo = "mdm_customer_sale_area", comment = "客户销售区域表")
public class CustomerSaleAreaEntity extends TenantOpEntity {


  private static final long serialVersionUID = 8903566498091804629L;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码'")
  private String customerCode;

  /**
   * 一级区域
   */
  @ApiModelProperty("一级区域")
  @Column(name = "area_one", length = 64, columnDefinition = "VARCHAR(64) COMMENT '一级区域'")
  private String areaOne;

  /**
   * 二级区域
   */
  @ApiModelProperty("二级区域")
  @Column(name = "area_two", length = 64, columnDefinition = "VARCHAR(64) COMMENT '二级区域'")
  private String areaTwo;

  /**
   * 三级区域
   */
  @ApiModelProperty("三级区域")
  @Column(name = "area_three", length = 64, columnDefinition = "VARCHAR(64) COMMENT '三级区域'")
  private String areaThree;

}
